/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;

public class AgentPropertiesService
implements ServiceLifecycle,
AgentService {
    private static final String AGENT_PROPERTY_PREFIX = "org.lsst.ccs.subsystem.agent.property.";
    private Properties agentProperties;
    private volatile boolean canSetAgentProperties = true;
    private static final Logger LOG = Logger.getLogger(AgentPropertiesService.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        this.agentProperties = agentInfo.getAgentProperties();
        this.agentProperties.putAll((Map<?, ?>)AgentPropertiesService.getDynamicAgentProperties());
        return true;
    }

    public static Properties getDynamicAgentProperties() {
        Properties dynamicProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
        dynamicProperties.putAll((Map<?, ?>)BootstrapResourceUtils.getBootstrapProperties((String)"agentProperties"));
        return AgentPropertiesService.loadFromProperties(dynamicProperties);
    }

    @Override
    public String getAgentServiceName() {
        return "propertiesService";
    }

    public void setAgentProperty(String property, String value) {
        if (!this.canSetAgentProperties) {
            throw new RuntimeException("Too late to set an Agent property. They must be set before the end of the HasLifecycle::init phase.");
        }
        this.agentProperties.setProperty(property, value);
    }

    @Override
    public void preBuild() {
        try {
            this.agentProperties.put("org.lsst.ccs.agent.hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            LOG.log(Level.FINEST, "Could not set hostname in agent properties.{0}", e);
        }
        this.agentProperties.put("org.lsst.ccs.agent.username", System.getProperty("user.name"));
        if (this.agentProperties.containsKey("org.lsst.ccs.use.full.paths")) {
            LOG.log(Level.INFO, "Full path property \"org.lsst.ccs.use.full.paths\" has been deprecated and can be removed.\n Full path is now the default for all Subsystems.");
        }
    }

    @Override
    public void preInit() {
        this.agentCommandDictionaryService.addCommandSetToObject(new AgentPropertiesServiceCommands(this), this.agent);
        this.setAgentProperty("runMode", RunMode.getRunMode().name().toLowerCase());
    }

    @Override
    public void afterInit() {
        this.canSetAgentProperties = false;
    }

    private static Properties loadFromProperties(Properties props) {
        Properties p = new Properties();
        for (Object property : BootstrapResourceUtils.getAllKeysInProperties((Properties)props)) {
            String prop = (String)property;
            if (!prop.startsWith(AGENT_PROPERTY_PREFIX)) continue;
            String agentProperty = prop.replace(AGENT_PROPERTY_PREFIX, "");
            String agentPropertyValue = props.getProperty(prop);
            LOG.log(Level.FINE, "Adding agent property {0}={1}", new Object[]{agentProperty, agentPropertyValue});
            p.put(agentProperty, agentPropertyValue);
        }
        return p;
    }

    public String getAgentProperty(String property) {
        return this.agentProperties.getProperty(property);
    }

    public Set getAgentPropertiesKeySet() {
        return new HashSet<Object>(this.agentProperties.keySet());
    }

    public Properties getAgentProperties() {
        return this.agentProperties;
    }

    public class AgentPropertiesServiceCommands {
        private final AgentPropertiesService propertiesService;

        AgentPropertiesServiceCommands(AgentPropertiesService propertiesService) {
            this.propertiesService = propertiesService;
        }

        @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY)
        public String getAgentProperty(String property) {
            return this.propertiesService.getAgentProperty(property);
        }

        @Command(category=Command.CommandCategory.SYSTEM, type=Command.CommandType.QUERY)
        public Set getAgentPropertiesKeySet() {
            return this.propertiesService.getAgentPropertiesKeySet();
        }

        @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY)
        public Properties getAgentProperties() {
            return this.propertiesService.getAgentProperties();
        }
    }
}

