/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.monitor.Monitor;

public class CalcChannel
extends DerivedChannel {
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    private Operation type = null;
    private List<String> channelPaths;
    private final List<Channel> channels = new ArrayList<Channel>();

    @Override
    void initSensor() {
        if (this.type == null) {
            throw new IllegalArgumentException("The field \"type\" must be provided to specify the type of operation to perform.");
        }
        if (this.channelPaths == null || this.channelPaths.isEmpty()) {
            throw new IllegalArgumentException("The field \"channelNames\" must be provided with the list of the Channel paths to be used to evaluate the value for this DerivedChannel.");
        }
        if (this.channelPaths.size() == 1) {
            throw new IllegalArgumentException("More than one channel path must be provided.");
        }
        if (this.channelPaths.size() > 2 && (this.type == Operation.DIFF || this.type == Operation.RATIO)) {
            throw new IllegalArgumentException("Operation of type " + (Object)((Object)this.type) + " only supports two Channels, but " + this.channelPaths.size() + " were provided.");
        }
        if (this.getDevice() == null) {
            throw new RuntimeException("No Device was specified for channel " + this.getPath());
        }
        for (String path : this.channelPaths) {
            Channel ch = this.mon.getChannel(path);
            if (ch == null) {
                throw new IllegalArgumentException("Invalid path: " + path + ". Could not find a corresponding Channel.");
            }
            if (!this.getDevice().equals(ch.getDevice())) {
                throw new IllegalArgumentException("Input Channel " + ch.getPath() + " belongs to a Device (\"" + ch.getDevice().getPath() + "\") which is different than the one for this Channel (\"" + this.getDevice() + "\")");
            }
            this.channels.add(ch);
        }
    }

    @Override
    public double evaluateDerivedValue() {
        for (Channel ch : this.channels) {
            if (ch.getState() != DataProviderState.OFF_LINE) continue;
            return Double.NaN;
        }
        switch (this.type) {
            case DIFF: {
                return this.channels.get(0).getValue() - this.channels.get(1).getValue();
            }
            case RATIO: {
                return this.channels.get(0).getValue() / this.channels.get(1).getValue();
            }
            case SUM: {
                double sum = 0.0;
                for (Channel ch : this.channels) {
                    sum += ch.getValue();
                }
                return sum;
            }
            case PROD: {
                double product = 0.0;
                for (Channel ch : this.channels) {
                    product *= ch.getValue();
                }
                return product;
            }
        }
        return Double.NaN;
    }

    public static enum Operation {
        SUM,
        DIFF,
        PROD,
        RATIO;

    }
}

