package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;

/**
 * An event for registering data groups.
 * @author LSST CCS Team
 */
class RegisterDataGroup {
    
    private final String agentName;
    private final boolean useFullPath;
    
    private final Map<String, List<DataDesc>> dataDescs = new HashMap<>();

    RegisterDataGroup(AgentInfo agentInfo) {
        this.agentName = agentInfo.getName();
        this.useFullPath = "true".equals(agentInfo.getAgentProperty("org.lsst.ccs.use.full.paths","false").toLowerCase());
    }
    
    void addDataDescToGroup(String group, DataDesc dd) {
        List<DataDesc> l = dataDescs.get(group);
        if (l == null) {
            l = new ArrayList<>();
            dataDescs.put(group, l);
        }
        l.add(dd);
    }

    public String getAgentName() {
        return agentName;
    }

    public boolean isUseFullPath() {
        return useFullPath;
    }
    
    public Map<String, List<DataDesc>> getDataDescs() {
        return dataDescs;
    }    
    
}
