package org.lsst.ccs.localdb.statusdb;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

/**
 * Alerts raised by localdb.
 * @author emarin
 */
public enum LocalDBAlert {
    BatchException("BatchException", "Exception caught when persisting batch"),
    BatchRollbackException("BatchRollbackException", "Exception caught when attempting to rollback batch"),
    BatchIngestionQueueSize("BatchIngestionQueueSize", "Ingestion Queue size Alert"),
    WrongStatePersistence("WrongStatePersistence", "Persistence layer persists two different agent states with the same id");
    
    private final String id, description;
    
    private final Map<String, Object> data = new HashMap<>();
    
    
    LocalDBAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    /**
     * Adds data to the Alert.
     * @param key
     * @param o
     * @return 
     */
    public LocalDBAlert addData(String key, Object o) {
        data.put(key, o);
        return this;
    }
    
    /**
     * Generates the actual {@code Alert} object.
     * @param prefix a prefix to add to the alertId.
     * @param ex an exception 
     * @return 
     */
    public Alert getAlert(String prefix, Exception ex) {
        String alertId = (prefix != null ? prefix+"/" : "") +id; 
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            data.put("stackTrace", sw.toString());
            pw.close();
        }
        return new Alert(alertId, description, data);
    }

    /**
     * An utility that returns the original cause of an exception.
     * @param ex
     * @return the string representation of the original exception.
     */
    public static String getFirstException(Exception ex){
        Throwable th = ex;
        while(th.getCause() != null) {
            th = th.getCause();
        }
        return th.toString();
    }
    
}
