/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class StatAccumulatorTest
extends LocaldbTestTemplate {
    private Agent persister;
    private DataDesc dd;
    private static final int BINWIDTH = 10;
    private static final int N_DATA = 1000;

    @BeforeClass
    public static void setupClass() {
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testStatAccumulator");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        p.setProperty("hibernate.show_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Before
    public void init() throws Exception {
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        this.dd = new DataDesc();
        this.dd.setDataType("trending");
        this.dd.setDataPath(new DataPath("data-publisher", "t1"));
        sess.persist((Object)this.dd);
        int[] customBinnings = new int[]{10};
        for (int i = 0; i < customBinnings.length; ++i) {
            StatDesc sd = new StatDesc();
            sd.setDataDesc(this.dd);
            sd.setTimeBinWidth((long)customBinnings[i]);
            sess.persist((Object)sd);
        }
        tx.commit();
        sess.close();
        this.persister = BootUtils.getSubsystemFromFile((String)"LocalDatabase");
    }

    @Test
    public void testOfflineAccumulation() {
        StatusDataPersister dataPersister = (StatusDataPersister)this.persister.getComponentLookup().getComponentByPath("data-persister");
        Object[][] scenario = new Object[1000][2];
        for (int i = 0; i < 1000; ++i) {
            scenario[i][0] = (long)i * 1L;
            scenario[i][1] = (double)((long)i / 10L * 10L);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RawData rd = new RawData();
            rd.setDataDesc(this.dd);
            rd.setTime(((Long)scenario[i][0]).longValue());
            rd.setDoubleData(Double.valueOf((Double)scenario[i][1]));
            dataPersister.getStatAccumulator().persist(rd, sess);
        }
        dataPersister.getStatAccumulator().flush(sess);
        tx.commit();
        sess.close();
        sess = sessionFactory.openSession();
        List sdList = sess.createQuery("from StatData sd where sd.statDesc.dataDesc=:dd and sd.statDesc.timeBinWidth=10").setEntity("dd", (Object)this.dd).list();
        Assert.assertEquals((String)"stat data list", (long)100L, (long)sdList.size());
        for (StatData sd : sdList) {
            Assert.assertEquals((String)("number of data in bin " + sd.getStatTimeInterval().getStartTime()), (long)10L, (long)sd.getN());
            Assert.assertEquals((double)sd.getStatTimeInterval().getStartTime(), (double)sd.getAverage(), (double)0.0);
            Assert.assertEquals((double)sd.getStatTimeInterval().getStartTime(), (double)sd.getMax(), (double)0.0);
            Assert.assertEquals((double)sd.getStatTimeInterval().getStartTime(), (double)sd.getMin(), (double)0.0);
        }
        sess.close();
    }
}

