/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class DemoSubsystemTest
extends LocaldbTestTemplate {
    private Agent persister;

    public static void setupClass() {
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public void init() throws Exception {
        this.persister = BootUtils.getSubsystemFromFile((String)"localdb");
        this.persister.startAgent();
        boolean started = this.persister.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)started);
    }

    public void testDemoSubsystem() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"DemoSubsystemWithMonitoring");
        s.startAgent();
        s.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        String agName = s.getName();
        Thread.sleep(10000L);
        s.shutdownAgent();
        DataServer ds = new DataServer();
        DataChannel.DataChannelList channels = ds.getChannels(agName, -1L);
        Map<String, DataChannel> channelMap = channels.list.stream().collect(Collectors.toMap(dc -> dc.getPathAsString(), dc -> dc));
        Set<String> keySet = channelMap.keySet();
        Assert.assertTrue((String)Arrays.toString(channelMap.keySet().toArray(new String[0])), (keySet.contains("/" + agName + "/DemoChannel11") && keySet.contains("/" + agName + "/DemoChannel12") && keySet.contains("/" + agName + "/DemoChannel21") && keySet.contains("/" + agName + "/DemoChannel22") ? 1 : 0) != 0);
        String ch11 = "/" + agName + "/DemoChannel11";
        String ch12 = "/" + agName + "/DemoChannel12";
        String ch21 = "/" + agName + "/DemoChannel21";
        String ch22 = "/" + agName + "/DemoChannel22";
        Map<String, ChannelMetaData> metaData = ds.getMetadataList((long)((long)((int)channelMap.get((Object)ch11).getId()))).list.stream().collect(Collectors.toMap(cmd -> cmd.getName(), cmd -> cmd, (cmd1, cmd2) -> cmd1));
        Set<String> metaDataNames = metaData.keySet();
        Assert.assertEquals((String)Arrays.toString(metaDataNames.toArray(new String[0])), (long)6L, (long)metaDataNames.size());
        Assert.assertTrue((boolean)metaDataNames.contains("devicemetadata"));
        Assert.assertTrue((boolean)metaDataNames.contains("alarmHigh"));
        Assert.assertTrue((boolean)metaDataNames.contains("alarmLow"));
        Assert.assertTrue((boolean)metaDataNames.contains("description"));
        Assert.assertTrue((boolean)metaDataNames.contains("format"));
        Assert.assertTrue((boolean)metaDataNames.contains("state"));
        List list = ds.getMetadataForChannel((int)channelMap.get(ch11).getId(), -1L, -1L).stream().filter(md -> md.getName().equals("devicemetadata")).collect(Collectors.toList());
        Assert.assertFalse((String)"metadata list should not be empty", (boolean)list.isEmpty());
        for (ChannelMetaData cmd3 : list) {
            Assert.assertEquals((long)1L, (long)(Integer.valueOf(cmd3.getValue()) % 2));
        }
        list = ds.getMetadataForChannel((int)channelMap.get(ch21).getId(), -1L, -1L).stream().filter(md -> md.getName().equals("devicemetadata")).collect(Collectors.toList());
        Assert.assertFalse((String)"metadata list should not be empty", (boolean)list.isEmpty());
        for (ChannelMetaData cmd3 : list) {
            Assert.assertEquals((long)0L, (long)(Integer.valueOf(cmd3.getValue()) % 2));
        }
    }

    public void shutdown() throws Exception {
        this.persister.shutdownAgent();
    }
}

