package org.lsst.ccs.localdb.trendserver;

import java.net.NetworkInterface;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.services.AgentPropertiesService;

/**
 * An agent wrapping the rest server.
 * @author LSST CCS Team
 */
public class RestServerAgent extends Subsystem implements HasLifecycle {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.localdb.trendserver");
    private RestServer rs;
    
    private final String hostAddr;
    private final String port;
    
    @LookupField(strategy = LookupField.Strategy.TREE)
    AgentPropertiesService agentPropertiesService;
    
    public RestServerAgent() throws Exception {
        super("rest-server", AgentInfo.AgentType.SERVICE);
        
        port = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.rest.server.port","8080");
        
        NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());

        if (ne.getInterfaceAddresses().size()>0) {
            hostAddr = ne.getInterfaceAddresses().get(0).getAddress().getHostAddress();
            log.info("trend server accessible through : " + hostAddr);
        
        } else {
            log.warn("cannot determine which network address to transmit");
            hostAddr = null;
        }
        
        
    }

    @Override
    public void build() {
        agentPropertiesService.setAgentProperty("rest-service-addr", hostAddr);
        agentPropertiesService.setAgentProperty("rest-service-port", port);
        agentPropertiesService.setAgentProperty("rest-service-entrypoint", "/rest/data");
        agentPropertiesService.setAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY, AgentCategory.REST_SERVER.name());
    }
    


    @Override
    public void startAgent() {
        super.startAgent(); 
        rs = new RestServer(Integer.valueOf(port));
        rs.start();
        log.info("RestServer stated on "+hostAddr+":"+port);
    }
    

    
    
}
