/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.configdb.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.AgentPresenceEvent;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.localdb.utils.InfluxDbClientService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public class ConfigurationPersister
implements ConfigurationDAO,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private ConfigurationFacade facade;
    private final Map<String, Description> aliveDescriptions = new HashMap<String, Description>();
    private final Map<String, CountDownLatch> descriptionReady = new HashMap<String, CountDownLatch>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent s;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    StatusDataPersister statusDataPersister;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    private final BlockingQueue<Object[]> ciQueue = new ArrayBlockingQueue<Object[]>(1000);

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("configuration-accumulator", (Runnable)new ConfigurationInfoPersister()).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
    }

    public void init() {
        this.s.setAgentProperty("org.lsst.ccs.config.service", "true");
    }

    public void start() {
        this.facade = new ConfigurationFacade(new HibernateDAO(StatusdbUtils.getSessionFactory(null)));
    }

    @Command
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDescription) throws ConfigurationServiceException {
        try {
            return this.facade.loadConfiguration(this.descriptionWaitAndGet(agentName).getBaseDescription(), configDescription);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        try {
            return this.facade.loadGlobalConfiguration(this.descriptionWaitAndGet(agentName).getBaseDescription(), name, version);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        try {
            return this.facade.findAvailableConfigurationsForCategory(this.descriptionWaitAndGet(agentName).getBaseDescription(), category);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public boolean isAvailable() {
        return true;
    }

    @Command
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            return this.facade.registerStandaloneConfiguration(this.descriptionWaitAndGet(agentName), configInfo);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return null;
    }

    private Description descriptionWaitAndGet(String agentName) {
        try {
            this.descriptionReady.get(agentName).await();
            return this.aliveDescriptions.get(agentName);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot get description for " + agentName, ex);
        }
    }

    private void processFirstStatusConfigurationInfo(StatusConfigurationInfo sci, ConfigurationInfoData cid) throws Exception {
        ConfigurationInfo ci = sci.getConfigurationInfo();
        String agentName = cid.getAgentDesc().getAgentName();
        Description desc = this.facade.registerDescription(cid.getAgentDesc(), ci.getAllParameterInfo());
        log.finest((Object)("registered description for " + agentName + " with id " + desc.getId()));
        this.facade.cleanupConfigurationRuns(desc, cid.getTime());
        this.facade.registerConfiguration(desc, ci, cid);
        log.finest((Object)("registered initial configuration info : " + ci.getConfigurationName() + " at " + sci.getCCSTimeStamp().getUTCInstant().toEpochMilli()));
        this.aliveDescriptions.put(agentName, desc);
    }

    public void submit(Object[] objs) {
        this.ciQueue.offer(objs);
    }

    private class ConfigurationInfoPersister
    implements Runnable {
        private ConfigurationInfoPersister() {
        }

        @Override
        public void run() {
            long tstart = System.currentTimeMillis();
            int nProcessed = 0;
            while (!ConfigurationPersister.this.ciQueue.isEmpty()) {
                try {
                    Object[] o = (Object[])ConfigurationPersister.this.ciQueue.take();
                    ++nProcessed;
                    Object key = o[0];
                    if (key instanceof ConfigurationInfoData) {
                        ConfigurationInfoData cid = (ConfigurationInfoData)key;
                        String name = cid.getAgentDesc().getAgentName();
                        StatusConfigurationInfo sci = (StatusConfigurationInfo)o[1];
                        Description desc = (Description)ConfigurationPersister.this.aliveDescriptions.get(name);
                        if (desc == null) {
                            ConfigurationPersister.this.processFirstStatusConfigurationInfo(sci, cid);
                            continue;
                        }
                        if (ConfigurationPersister.this.descriptionReady.get(name) != null) {
                            ((CountDownLatch)ConfigurationPersister.this.descriptionReady.get(name)).countDown();
                            ConfigurationPersister.this.facade.registerStandaloneStatusConfigurationInfo((Description)ConfigurationPersister.this.aliveDescriptions.get(name), cid);
                            continue;
                        }
                        log.fine((Object)("received configuration state at : " + sci.getCCSTimeStamp().getUTCInstant().toEpochMilli() + " : " + sci.getConfigurationInfo().getConfigurationName()));
                        ConfigurationPersister.this.facade.registerConfiguration((Description)ConfigurationPersister.this.aliveDescriptions.get(name), sci.getConfigurationInfo(), cid);
                        continue;
                    }
                    if (key instanceof AgentPresenceEvent) {
                        AgentPresenceEvent ape = (AgentPresenceEvent)key;
                        AgentInfo agent = ape.getAgent();
                        if (ape.isConnecting()) {
                            String remote = agent.getAgentProperty("org.lsst.ccs.config.remote");
                            if (!"true".equals(remote)) continue;
                            log.finest((Object)("got connection event from " + agent.getName()));
                            ConfigurationPersister.this.descriptionReady.put(agent.getName(), new CountDownLatch(1));
                            continue;
                        }
                        log.finest((Object)("got disconnection event from " + agent.getName()));
                        Description desc = (Description)ConfigurationPersister.this.aliveDescriptions.remove(agent.getName());
                        if (desc == null) continue;
                        ConfigurationPersister.this.facade.stopConfigurationRuns(desc, ape.getTime());
                        continue;
                    }
                    log.info((Object)("configuration persister received unexpected object " + key.getClass()));
                }
                catch (InterruptedException ex) {
                    log.debug((Object)"configuration info serializer thread interrupted", (Throwable)ex);
                    return;
                }
                catch (Exception ex) {
                    log.severe((Object)"caught exception when persisting", (Throwable)ex);
                    ConfigurationPersister.this.alertService.raiseAlert(LocalDBAlert.ConfigurationPersistenceException.getAlert(null, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
                }
            }
            if (nProcessed > 0) {
                long time = System.currentTimeMillis() - tstart;
                if (ConfigurationPersister.this.influxDbClientService.getInfluxDbClient() != null) {
                    Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    batchPersisterPointBuilder = batchPersisterPointBuilder.addField("time_tot", time).addField("count", (long)nProcessed).addField("time_avg", (double)time / (double)nProcessed);
                    Point point = batchPersisterPointBuilder.tag("persister", ConfigurationPersister.this.name).build();
                    ConfigurationPersister.this.influxDbClientService.getInfluxDbClient().write(point);
                } else {
                    KeyValueDataList kvdl = new KeyValueDataList(ConfigurationPersister.this.name);
                    kvdl.addData(ConfigurationPersister.this.name + "/transactionTime", (Serializable)Long.valueOf(time));
                    kvdl.addData(ConfigurationPersister.this.name + "/entityAverageTime", (Serializable)Double.valueOf((double)time / (double)nProcessed));
                    ConfigurationPersister.this.statusDataPersister.processEncodedData(ConfigurationPersister.this.s.getName(), kvdl);
                }
            }
        }
    }
}

