/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BatchPersister<T>
implements Runnable,
ClearAlertHandler {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    @LookupName
    private String persisterName;
    private static final int CONSECUTIVE_MAX_CAPACITY_LIMIT = 15;
    private final int nMax;
    private final boolean flushAtCommit;
    private final Queue<T> rq = new ConcurrentLinkedQueue<T>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent a;
    @LookupField(strategy=LookupField.Strategy.TREE)
    StatusDataPersister statusDataPersister;
    private int maxCapacityCount = 0;

    public BatchPersister(int nMax, boolean flushAtCommit) {
        this.nMax = nMax;
        this.flushAtCommit = flushAtCommit;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        int nAcc = 0;
        boolean empty = false;
        long tstart = System.currentTimeMillis();
        while (!empty) {
            Session sess = StatusdbUtils.getSessionFactory(null).openSession();
            if (this.flushAtCommit) {
                sess.setFlushMode(FlushMode.COMMIT);
            }
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                for (int i = 0; i < this.nMax; ++i) {
                    T t = this.rq.poll();
                    n = i;
                    if (t == null) {
                        this.maxCapacityCount = 0;
                        empty = i == 0;
                        break;
                    }
                    this.persist(t, sess);
                    if (i != this.nMax - 1) continue;
                    ++this.maxCapacityCount;
                }
                if (!empty) {
                    tx.commit();
                }
                if (this.maxCapacityCount == 15) {
                    this.alertService.raiseAlert(LocalDBAlert.BatchMaxCapacity.getAlert(this.persisterName, null), AlertState.WARNING, "current queue size : " + this.rq.size());
                    this.maxCapacityCount = 0;
                }
            }
            catch (Exception ex) {
                log.error((Object)"caught exception when persisting", (Throwable)ex);
                this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
                try {
                    if (tx != null && (tx.getStatus() == TransactionStatus.ACTIVE || tx.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                        tx.rollback();
                    }
                }
                catch (Exception rbEx) {
                    log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                    this.alertService.raiseAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
                }
            }
            finally {
                if (sess.isOpen()) {
                    sess.close();
                }
            }
            if (n <= 0) continue;
            nAcc += n;
            log.debug((Object)(this.getClass().getSimpleName() + " processed " + n + " entities."));
        }
        if (nAcc > 0) {
            long time = System.currentTimeMillis() - tstart;
            KeyValueDataList kvdl = new KeyValueDataList(this.persisterName);
            kvdl.addData(this.persisterName + "/transactionTime", (Serializable)Long.valueOf(time));
            kvdl.addData(this.persisterName + "/entityAverageTime", (Serializable)Double.valueOf((double)time / (double)nAcc));
            this.statusDataPersister.processEncodedData(this.a.getName(), kvdl);
        }
    }

    public void addToQueue(T obj) {
        this.rq.add(obj);
    }

    public abstract void persist(T var1, Session var2);
}

