package org.lsst.ccs.localdb.trendserver;

import java.net.NetworkInterface;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.messaging.NetworkUtilities;

/**
 * An agent wrapping the rest server.
 * @author LSST CCS Team
 */
public class RestServerAgent extends Subsystem {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.localdb.trendserver");
    private RestServer rs;
    
    private final String hostAddr;
    private final String port;
    
    public RestServerAgent() throws Exception {
        super("rest-server", AgentInfo.AgentType.SERVICE);
        
        port = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.rest.server.port","8080");
        
        NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());

        if (ne.getInterfaceAddresses().size()>0) {
            hostAddr = ne.getInterfaceAddresses().get(0).getAddress().getHostAddress();
            log.info("trend server accessible through : " + hostAddr);
        
        } else {
            log.warn("cannot determine which network address to transmit");
            hostAddr = null;
        }
        
        setAgentProperty("rest-service-addr", hostAddr);
        setAgentProperty("rest-service-port", port);
        setAgentProperty("rest-service-entrypoint", "/rest/data");
        
    }

    @Override
    public void startAgent() {
        super.startAgent(); 
        rs = new RestServer(Integer.valueOf(port));
        rs.start();
        log.info("RestServer stated on "+hostAddr+":"+port);
    }
    

    
    
}
