/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.cluster.monitor.Counter;

class Accumulate {
    private final Map<String, double[]> accumulateMap = new HashMap<String, double[]>();
    private final Counter counter = new Counter();

    Accumulate() {
    }

    public synchronized void accumulate(double value, String key) {
        double[] valueWrapper = this.accumulateMap.get(key);
        this.counter.increment(key);
        if (valueWrapper == null) {
            this.accumulateMap.put(key, new double[]{value});
        } else {
            valueWrapper[0] = valueWrapper[0] + value;
        }
    }

    public Map<String, Double> getAverageMap() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (String key : this.accumulateMap.keySet()) {
            result.put(key, this.accumulateMap.get(key)[0] / (double)this.counter.getCountersMap().get(key).intValue());
        }
        return result;
    }
}

