package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;

/**
 * Batch persistence of MetaDataData entities.
 * @author LSST CCS Team
 */
public class MetaDataPersister extends BatchPersister<Object> {
    
    public MetaDataPersister() {
        super(3000, false);
    }
    
    @Override
    public void persist(Object obj, Session sess) {
        if (obj instanceof MetaDataData) {
            persistMetaData((MetaDataData)obj, sess);
        } else if (obj instanceof CloseMetaData) {
            closeMetaData((CloseMetaData)obj, sess);
        }
    }
    
    private void persistMetaData(MetaDataData md, Session sess) {
        
        // First update the tstop of a previously existing record for this
        // metadata
        Query q = sess.createQuery("from MetaDataData md " + "where dataGroup.id = :id " + "and name = :n and endTime <= 0");
        q.setParameter("id", md.getDataGroup().getId());
        q.setParameter("n", md.getName());
        MetaDataData oldMetaData = (MetaDataData) q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setEndTime(md.getStartTime());
        }
        // Now commit the new value of the metadata
        sess.persist(md);
    }
    
    private void closeMetaData(CloseMetaData cmd, Session sess) {
        // TODO : connecting does not propagate the timestamp of the status message that triggered it
        long time = System.currentTimeMillis();
        // Closing the existing open meta data for the corresponding agent
        Query q = sess.createQuery("from MetaDataData md where dataGroup.agentName=:agName and endTime <= 0");
        q.setString("agName", cmd.agentName);
        List<MetaDataData> res = q.list();
        for(MetaDataData md : res) {
            md.setEndTime(time);
        }
    }
    
}
