package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;

/**
 * An event for registering data groups.
 * @author LSST CCS Team
 */
class RegisterDataGroup {
    
    final String agentName;
    
    final Map<String, List<DataDesc>> dataDescs = new HashMap<>();

    RegisterDataGroup(String agentName) {
        this.agentName = agentName;
    }
    
    void addDataDescToGroup(String group, DataDesc dd) {
        List<DataDesc> l = dataDescs.get(group);
        if (l == null) {
            l = new ArrayList<>();
            dataDescs.put(group, l);
        }
        l.add(dd);
    }
    
}
