/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.CCSBuilder;

public class BootUtils {
    private BootUtils() {
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static ComponentLookup buildComponentLookupFromDescription(String fullDescription, String config) throws Exception {
        if (config != null) {
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
        }
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)fullDescription, (String)config);
        return lookup;
    }

    public static Subsystem getSubsystemFromLookup(ComponentLookup componentLookup, String alias) throws Exception {
        Subsystem subsystem;
        ComponentNode topNode = componentLookup.getTopComponentNode();
        Object topObj = topNode.getComponent();
        if (Subsystem.class.isAssignableFrom(topObj.getClass())) {
            subsystem = (Subsystem)topObj;
            if (alias != null) {
                subsystem.setAgentName(alias);
            }
        } else {
            String subsystemName = alias != null ? alias : CCSBuilder.getSubsystemName();
            subsystem = new Subsystem(subsystemName, AgentInfo.AgentType.WORKER, componentLookup);
        }
        subsystem.populateComponentLookup(componentLookup);
        String applicationName = BootstrapResourceUtils.getBootstrapProperties((String)"system").getProperty("org.lsst.ccs.application.name", "");
        if (subsystem.getName().equals(applicationName)) {
            throw new RuntimeException("The name of the subsystem must be different than the name of the application properties file from which it is created: " + subsystem.getName() + "\nPlease rename either one.");
        }
        return subsystem;
    }

    public static Subsystem getSubsystemFromFile(String fullDescription, String config, String alias) throws Exception {
        ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(fullDescription, config);
        return BootUtils.getSubsystemFromLookup(lookup, alias);
    }

    public static void main(String[] argv) throws Exception {
        String descriptionName = argv[0];
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)descriptionName);
        Map map = lookup.getChildren(lookup.getTopComponentNode(), null);
        System.out.println("Build object tree: " + lookup.getTopComponentNode().getKey());
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("--> " + (String)entry.getKey() + "        \t" + entry.getValue().getClass());
        }
    }
}

