package org.lsst.ccs.localdb.statusdb;

import java.math.BigInteger;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.startup.HasCommandLineOptions;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Subsystem wrapper around a StatusDataPersister object
 */
public class StatusPersisterSubsystem extends Subsystem implements HasCommandLineOptions {
    private final Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    
    private static SessionFactory fac;
    
    private Properties p;
    
    // define the command line options
    private final Options commandLineOptions = new Options();
    
    private static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory(p);
    }
    
    public StatusPersisterSubsystem()  {
        super("localdb", AgentInfo.AgentType.SERVICE);
        
        if (p == null) {
            p = BootstrapResourceUtils.getBootstrapSystemProperties(); 
        }
        commandLineOptions.addOption("u", "update", false, 
                "Start the Trending Ingest Module in update mode.");     
    }
    
    @Override
    public void startAgent() {
        init(p);
        
        // Make sure that migration of AgentState table has been made
        Session sess = fac.openSession();
        SQLQuery somethingToMigrate = sess.createSQLQuery("select count(*) from ccs_agentSt_innerStDe_b");

        int nEntries = ((BigInteger)somethingToMigrate.uniqueResult()).intValue();
        
        sess.close();
        
        if(nEntries > 0 ) {
            throw new RuntimeException("localdb cannot start because the MigrateAgentStates application has not been run yet.");
        }
        
        super.startAgent();
    }
    
    @Override
    public void doStart() {
        getScheduler().scheduleAtFixedRate(
                () -> {
                    publishSubsystemDataOnStatusBus(new KeyValueData("statistics", new CacheStatistics(fac)));
                }
                , 1, 5, TimeUnit.MINUTES);
        log.info(getName() + " started");
    }
    
    @Override
    public void processCommandLineOptions(String[] args) throws ParseException {
        CommandLineParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            
            if (line.hasOption("update")) {
                p.setProperty("hibernate.hbm2ddl.auto", "update");
            }

        } catch (Exception e) {
            printHelp();
        }
    }

    @Override
    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "TrendingIngestModule", "", commandLineOptions, "", true);
    }
    
    
    
}
