/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.CalcDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Page;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor
implements HasLifecycle {
    private static final int DEFAULT_UPDATE_PERIOD = 1000;
    private static final int DEFAULT_CHECK_PERIOD = 10000;
    static final String CALC_DEVICE_NAME = "Calc";
    static final String LIMITS = "Limits";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Device> devcMap = new HashMap<String, Device>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> chanMap = new LinkedHashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Alarm> alarmMap = new HashMap<String, Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Line> lineMap = new HashMap<String, Line>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Page> pageMap = new LinkedHashMap<String, Page>();
    private final BitSet goodChans = new BitSet();
    private final BitSet onlineChans = new BitSet();
    private final CalcDevice calcDevc = new CalcDevice();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<AlarmHandler> alarmHandlers = new ArrayList<AlarmHandler>();
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    List<Alarm> monitorAlarms = new ArrayList<Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    final BitSet loLimChange = new BitSet();
    final BitSet hiLimChange = new BitSet();
    private boolean readyToPublish = false;
    private int numChans;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Channel> chanData = new ArrayList<Channel>();
    private boolean doPublishData;
    public static final String MONITOR_CHECK_TASK = "monitor-check";
    public static final String MONITOR_UPDATE_TASK = "monitor-update";
    public static final String MONITOR_PUBLISH_TASK = "monitor-publish";

    public Monitor(Agent a) {
        this(a, null);
    }

    public static Monitor create(Agent agent) {
        ComponentLookup lookup = agent.getComponentLookup();
        ArrayList devices = new ArrayList();
        TreeWalkerUtils.proceduralWalk(lookup, null, Device.class, dev -> devices.add(dev), null);
        if (devices.size() > 0) {
            Monitor monitor = new Monitor(agent);
            lookup.addComponentNodeToLookup(lookup.getTopComponentNode().getKey(), new ComponentNode(lookup.getTopComponentNode(), "monitor", (Object)monitor));
            return monitor;
        }
        return null;
    }

    protected Monitor() {
    }

    protected Monitor(Agent a, AlarmHandler alarmHand) {
        if (!(a instanceof Subsystem)) {
            throw new RuntimeException("Monitor cannot be created for an Agent");
        }
    }

    @Override
    public void start() {
        this.readyToPublish = true;
    }

    @Override
    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_UPDATE_TASK, () -> {
            this.readSensors();
            this.updateState();
        }).withPeriod(Duration.ofMillis(1000L)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_CHECK_TASK, () -> {
            for (String devName : this.getDeviceNames()) {
                this.getDevice(devName).checkOnline();
            }
        }).withPeriod(Duration.ofMillis(10000L)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_PUBLISH_TASK, () -> {
            this.doPublishData = true;
        }).withPeriod(Duration.ofMillis(10000L)));
    }

    @Override
    public void init() {
        this.log = Logger.getLogger((String)(this.subsys.getLogger().getName() + ".monitor"));
        this.log.finest((Object)"Initializing monitor framework");
        this.devcMap.put(CALC_DEVICE_NAME, this.calcDevc);
        for (Device devc : this.devcMap.values()) {
            devc.configure(this);
        }
        for (Line line : this.lineMap.values()) {
            line.configure(this);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            alarm.configure();
        }
        for (Channel ch : this.chanData) {
            ch.configure(this, this.chanData.indexOf(ch));
        }
        AlarmHandler defaultHandler = new AlarmHandler(){

            @Override
            public boolean processAlarm(int event, int parm, String cause, String name) {
                AlertState state;
                switch (event) {
                    case 0: {
                        state = AlertState.ALARM;
                        break;
                    }
                    case 1: {
                        state = AlertState.WARNING;
                        break;
                    }
                    case 2: {
                        state = AlertState.WARNING;
                        break;
                    }
                    case 3: {
                        state = AlertState.NOMINAL;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unkwnown event value " + event);
                    }
                }
                Monitor.this.subsys.getAlertService().raiseAlert(new Alert("MonitorAlert" + parm, name), state, "Automatic Monitor Alert\n" + cause);
                return true;
            }

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
                String idStr = alert.getAlertId().replace("MonitorAlert", "");
                try {
                    int id = Integer.parseInt(idStr);
                    Alarm a = this.getAlarmById(id);
                    if (a != null) {
                        a.clearState();
                        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
            }
        };
        this.alarmHandlers.add(defaultHandler);
        this.subsys.getAlertService().addClearAlertHandler(defaultHandler);
        for (AlarmHandler handler : this.alarmHandlers) {
            handler.setAlarms(this.monitorAlarms);
        }
    }

    public void readSensors() {
        for (Device devc : this.devcMap.values()) {
            devc.readSensors();
        }
    }

    @Override
    public void postStart() throws HardwareException {
        this.publishMonitorState();
        this.publishMonitorLimits();
    }

    public MonitorFullState getFullState() {
        return this.getMonitorFullState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full monitoring state")
    public MonitorFullState getMonitorFullState() {
        MonitorFullState state = new MonitorFullState();
        for (Alarm alarm : this.alarmMap.values()) {
            state.addAlarm(alarm.getName(), alarm.getDescription());
        }
        for (Page page : this.pageMap.values()) {
            state.addPage(Integer.valueOf(page.getId()), page.getLabel());
        }
        for (Channel ch : this.chanData) {
            state.addChannel(new MonitorChan(ch.getName(), ch.getDescription(), ch.getFormat(), ch.getUnits(), ch.getPageId(), ch.getLimitLo(), 0.0, ch.getAlarmNameLo(), ch.getLimitHi(), 0.0, ch.getAlarmNameHi(), ch.getValue()));
        }
        state.setMonitorState(new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange));
        return state;
    }

    void publishMonitorState() {
        if (this.readyToPublish) {
            MonitorState state = new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange);
            KeyValueData data = new KeyValueData("MonitorState", (Serializable)state);
            this.subsys.publishSubsystemDataOnStatusBus(data);
        }
    }

    private void publishMonitorLimits() {
        if (this.readyToPublish) {
            for (Channel ch : this.chanData) {
                KeyValueDataList data = new KeyValueDataList(ch.getName());
                data.addData("alarmLow", (Serializable)((Object)String.valueOf(ch.getLimitLo())), KeyValueData.KeyValueDataType.KeyValueMetaData);
                data.addData("alarmHigh", (Serializable)((Object)String.valueOf(ch.getLimitHi())), KeyValueData.KeyValueDataType.KeyValueMetaData);
                this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
            }
        }
    }

    private void updateState() {
        StateBundle sb = new StateBundle(new Enum[0]);
        BitSet goodState = new BitSet(this.numChans);
        BitSet onlineState = new BitSet(this.numChans);
        for (Channel ch : this.chanData) {
            ch.checkLimits(goodState);
            ch.checkOnline(onlineState);
            sb.setComponentState(ch.getName(), new Enum[]{ch.getState()});
        }
        this.subsys.updateAgentState(sb);
        for (Alarm alarm : this.alarmMap.values()) {
            alarm.setState();
        }
        goodState.xor(this.goodChans);
        this.goodChans.xor(goodState);
        onlineState.xor(this.onlineChans);
        this.onlineChans.xor(onlineState);
        if (!goodState.isEmpty() || !onlineState.isEmpty()) {
            this.publishMonitorState();
        }
        if (!goodState.isEmpty() || this.doPublishData) {
            KeyValueDataList dataList = new KeyValueDataList();
            for (Channel ch : this.chanData) {
                if (ch.getState() == DataProviderState.OFF_LINE || !ch.hasValidData() || !this.doPublishData && (this.doPublishData || !goodState.get(ch.getId()))) continue;
                dataList.addData(ch.getName(), (Serializable)Double.valueOf(ch.getValue()), ch.getTimestamp());
                ch.setDataInvalid();
            }
            if (!dataList.getListOfKeyValueData().isEmpty() && this.readyToPublish) {
                this.log.debug((Object)("Publishing Monitor data for " + this.subsys.getName() + " key: " + dataList.getKey() + " entries: " + dataList.getListOfKeyValueData().size()));
                this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
            }
            this.doPublishData = false;
        }
    }

    @Deprecated
    public void setPublishData() {
        this.doPublishData = true;
    }

    public void clearLimitChanges() {
        this.loLimChange.clear();
        this.hiLimChange.clear();
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices")
    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    public Line getLine(String name) {
        return this.lineMap.get(name);
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData.get(id);
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishMonitorState();
        }
    }

    public int getNumChans() {
        return this.numChans;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value")
    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value")
    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.readValue());
    }

    @Command(type=Command.CommandType.ACTION, description="Save the monitoring limits")
    public void saveLimits() {
        this.subsys.getConfigurationService().saveChangesForCategories(LIMITS);
        this.clearLimitChanges();
        this.publishMonitorState();
    }

    @Command(type=Command.CommandType.ACTION, description="Drop the changes to the monitoring limits")
    public void dropLimitChanges() {
        this.subsys.getConfigurationService().dropChangesForCategories(LIMITS);
        this.clearLimitChanges();
        this.publishMonitorState();
    }

    public List<AlarmHandler> getAlarmHandlersList() {
        return this.alarmHandlers;
    }

    public static interface AlarmHandler
    extends ClearAlertHandler {
        public static final List<Alarm> alarms = new ArrayList<Alarm>();

        default public boolean processAlarm(int event, int parm, String cause, String alarmName) {
            return false;
        }

        @Override
        default public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
            return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
        }

        default public void setAlarms(List<Alarm> alarms) {
            AlarmHandler.alarms.addAll(alarms);
        }

        default public Alarm getAlarmById(int id) {
            for (Alarm alarm : alarms) {
                if (alarm.eventParm != id) continue;
                return alarm;
            }
            return null;
        }
    }
}

