/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.statusdb.AlertPublisherSubsystem;
import org.lsst.ccs.localdb.statusdb.TrendingPublisherAgent;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class TrendingPublisherTest
extends LocaldbTestTemplate {
    private Agent persister;
    private static final String alertPublisherName = "alertRaiser";
    private static final String trendingPublisherName = "trendingSub";
    private static String[][] tempTrendingNames;
    private static final Map<String, AlertProfile> alertProfiles;

    @BeforeClass
    public static void setupClass() {
        alertProfiles.put("AL001", new AlertProfile("AL001", "AL #001", "some Temp is high", 20, 10, 5, true, 90));
        alertProfiles.put("AL002", new AlertProfile("AL002", "AL #002", "some Pressure is off", 20, 12, 5, false, 90));
        alertProfiles.put("AL003", new AlertProfile("AL003", "AL #003", "no idea", 20, 10, 5, false, 90));
        tempTrendingNames = new String[][]{{trendingPublisherName, "temp", "K"}, {trendingPublisherName, "temp2/tempData1", "K"}, {trendingPublisherName, "temp2/tempData2", "F"}, {trendingPublisherName, "temp2/tempData3", "C"}, {trendingPublisherName, "t1", "K"}, {trendingPublisherName, "t2", "C"}};
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Before
    public void init() throws Exception {
        int[] customBinnings;
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        DataDesc dd = new DataDesc();
        dd.setDataType("trending");
        dd.setDataPath(new DataPath(trendingPublisherName, "t1"));
        sess.persist((Object)dd);
        for (int b : customBinnings = new int[]{3000, 30000, 300000, 1800000}) {
            StatDesc sd = new StatDesc();
            sd.setDataDesc(dd);
            sd.setTimeBinWidth((long)b);
            sess.persist((Object)sd);
        }
        tx.commit();
        sess.close();
        this.persister = BootUtils.getSubsystemFromFile((String)"localdb");
        this.persister.startAgent();
    }

    @After
    public void tearDown() throws Exception {
        this.persister.shutdown();
    }

    @Test
    public void testTrendingOverBuses() throws Exception {
        Query q;
        int nPub = 1000;
        int nThreads = 1;
        int intervalMillis = 40;
        int trendingPublicationTime = nPub * intervalMillis + 10000;
        int alertPublicationTime = alertProfiles.values().stream().mapToInt(ap -> ap.interval * ap.total).max().getAsInt() + 10000;
        TrendingPublisherAgent trendingDataPublisher = new TrendingPublisherAgent(trendingPublisherName);
        trendingDataPublisher.startAgent();
        AlertPublisherSubsystem alertRaiser = new AlertPublisherSubsystem(alertPublisherName);
        alertRaiser.startAgent();
        alertRaiser.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 30L, TimeUnit.SECONDS);
        trendingDataPublisher.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 30L, TimeUnit.MILLISECONDS);
        trendingDataPublisher.fireTemperatureDataPublication(nPub, nThreads, intervalMillis);
        alertRaiser.fireAlertsRaising(alertProfiles.values());
        boolean b1 = alertRaiser.waitFor(state -> state.isInState((Enum)AlertPublisherSubsystem.State.IDLE), alertPublicationTime, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"subsystem did not stop within specified timeout ", (boolean)b1);
        boolean b2 = trendingDataPublisher.waitFor(state -> state.isInState((Enum)TrendingPublisherAgent.State.IDLE), trendingPublicationTime, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)("subsystem did not stop within specified timeout " + trendingPublicationTime), (boolean)b2);
        Thread.sleep(10000L);
        Session sess = sessionFactory.openSession();
        HashMap<String, Integer> NActiveAlerts = new HashMap<String, Integer>();
        for (AlertProfile alertProfile : alertProfiles.values()) {
            q = sess.createQuery("from RaisedAlertData arad where arad.alertDesc.alertId=:id and arad.active=true").setString("id", alertProfile.alertId);
            List res = q.list();
            Assert.assertNotNull((String)("active alerts for " + alertProfile.alertId), (Object)res);
            NActiveAlerts.put(alertProfile.alertId, res.size());
            Assert.assertTrue((String)("number of " + alertProfile.alertId + " active alerts : " + res.size()), (res.size() >= 3 ? 1 : 0) != 0);
            for (RaisedAlertData arad : res) {
                Assert.assertEquals((String)"Alert Description", (Object)arad.getAlertCause(), (Object)alertProfile.alertCause);
            }
        }
        int nCleared = 0;
        for (AlertProfile ap3 : alertProfiles.values()) {
            if (!ap3.clear.booleanValue()) continue;
            ++nCleared;
            alertRaiser.getAlertService().clearAlerts(new String[]{ap3.alertId});
        }
        sess.close();
        Thread.sleep(15000L);
        sess = sessionFactory.openSession();
        Query query = sess.createQuery("select count(*) from RawData rd where rd.dataDesc.dataPath.agentName=:agentName and rd.dataDesc.dataPath.dataName=:dataName");
        Query qmdd = sess.createQuery("select mdd.value from MetaDataData mdd where mdd.dataDesc.dataPath.agentName=:agentName and mdd.dataDesc.dataPath.dataName=:dataName and mdd.name=:metadataname and mdd.endTime <= 0");
        for (int i = 0; i < tempTrendingNames.length; ++i) {
            query.setString("agentName", tempTrendingNames[i][0]);
            query.setString("dataName", tempTrendingNames[i][1]);
            int res = (int)((Long)query.uniqueResult()).longValue();
            Assert.assertEquals((String)(tempTrendingNames[i][0] + "/" + tempTrendingNames[i][1]), (long)nPub, (long)res);
            qmdd.setString("agentName", tempTrendingNames[i][0]);
            qmdd.setString("dataName", tempTrendingNames[i][1]);
            qmdd.setString("metadataname", "unit");
            String string = (String)qmdd.uniqueResult();
            Assert.assertEquals((String)("metadata for : " + tempTrendingNames[i][0] + "/" + tempTrendingNames[i][1]), (Object)tempTrendingNames[i][2], (Object)string);
        }
        q = sess.createQuery("from StatDesc sd where sd.dataDesc.dataPath.agentName=:agentName and sd.dataDesc.dataPath.dataName=:dataName");
        q.setString("agentName", trendingPublisherName);
        q.setString("dataName", "t1");
        List statDescs = q.list();
        for (StatDesc statDesc : statDescs) {
            q = sess.createQuery("from StatData sd where sd.statDesc.id=:statDescId");
            q.setLong("statDescId", statDesc.getId());
            List statdatas = q.list();
            int tot = 0;
            long endTime = 0L;
            for (StatData statdata : statdatas) {
                tot += statdata.getN();
                if (statdata.getStatTimeInterval().getEndTime() <= endTime) continue;
                endTime = statdata.getStatTimeInterval().getEndTime();
            }
            long nPubWithStats = (Long)sess.createQuery("select count(*) from RawData rd where rd.dataDesc=:dataDesc and rd.time <:endTime").setEntity("dataDesc", (Object)statDesc.getDataDesc()).setLong("endTime", endTime).uniqueResult();
            Assert.assertEquals((String)("unbinned data with width : " + statDesc.getTimeBinWidth()), (long)nPubWithStats, (long)tot);
        }
        q = sess.createQuery("from RaisedAlertData arad where arad.agentDesc.agentName=:name and arad.alertDesc.alertId=:id and arad.active=true").setString("name", alertPublisherName);
        for (AlertProfile alertProfile : alertProfiles.values()) {
            q.setString("id", alertProfile.alertId);
            List res = q.list();
            for (RaisedAlertData arad : res) {
                ClearedAlertData cad = arad.getClearingAlert();
                if (alertProfile.clear.booleanValue()) {
                    Assert.assertNotNull((Object)cad);
                    Assert.assertEquals((Object)alertProfile.alertId, (Object)cad.getAlertDesc().getAlertId());
                    continue;
                }
                Assert.assertNull((Object)cad);
            }
        }
        List adList = sess.createQuery("from AlertDesc").list();
        Assert.assertEquals((long)alertProfiles.size(), (long)adList.size());
        for (Object ad : adList) {
            Assert.assertEquals((Object)alertPublisherName, (Object)ad.getAgentDesc().getAgentName());
            AlertProfile ap5 = alertProfiles.get(ad.getAlertId());
            Assert.assertNotNull((Object)ap5);
            Assert.assertEquals((String)"AlertDesc description", (Object)ap5.alertDesc, (Object)ad.getAlertDescription());
            Assert.assertEquals((String)"AlertDesc Id", (Object)ap5.alertId, (Object)ad.getAlertId());
        }
        q = sess.createQuery("from ClearedAlertData");
        List list = q.list();
        Assert.assertEquals((long)nCleared, (long)list.size());
        for (ClearedAlertData cad : list) {
            AlertProfile ap6 = alertProfiles.get(cad.getAlertDesc().getAlertId());
            Assert.assertTrue((String)(ap6.alertId + " should not have been cleared"), (boolean)ap6.clear);
            Assert.assertEquals((String)("number of cleared alerts for : " + ap6.alertId), (long)((Integer)NActiveAlerts.get(ap6.alertId)).intValue(), (long)cad.getClearedAlerts().size());
        }
        Query stateQuery = sess.createQuery("select arad.agentState from RaisedAlertData arad where arad.active=true");
        List resStateQuery = stateQuery.list();
        for (Object agst : resStateQuery) {
            Map externalStates = ((StateBundleDesc)agst.getComponentStates().get("")).getComponentStates();
            Assert.assertEquals((String)"size of inner states : ", (long)1L, (long)externalStates.size());
            String enumClassName = AlertPublisherSubsystem.State.class.getName();
            InnerStateDesc isd = (InnerStateDesc)externalStates.get(enumClassName);
            Assert.assertNotNull((String)("could not find value for key : " + enumClassName), (Object)isd);
        }
        trendingDataPublisher.shutdown();
        alertRaiser.shutdown();
        boolean stopped = alertRaiser.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"subsystem did not stop within specified timeout", (boolean)stopped);
        Thread.sleep(5000L);
        q = sess.createQuery("from RaisedAlertData arad where arad.agentDesc.agentName=:name and arad.active=true").setString("name", alertPublisherName);
        List list2 = q.list();
        Assert.assertEquals((String)q.getQueryString(), (long)0L, (long)list2.size());
        q = sess.createQuery("from RaisedAlertData ad where ad.alertDesc.alertId=:name and ad.active=false");
        for (AlertProfile ap7 : alertProfiles.values()) {
            String alertId = ap7.alertId;
            q.setString("name", alertId);
            List list3 = q.list();
            Assert.assertEquals((String)alertId, (long)((Integer)NActiveAlerts.get(alertId)).intValue(), (long)list3.size());
        }
        sess.close();
        sess = sessionFactory.openSession();
        q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name").setString("name", alertPublisherName);
        List scnds = q.list();
        Assert.assertTrue((scnds.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < scnds.size() - 1; ++i) {
            Assert.assertEquals((Object)((StateChangeNotificationData)scnds.get(i + 1)).getOldState(), (Object)((StateChangeNotificationData)scnds.get(i)).getNewState());
        }
        sess.close();
    }

    static {
        alertProfiles = new HashMap<String, AlertProfile>();
    }

    static class AlertProfile {
        final String alertId;
        final String alertDesc;
        final String alertCause;
        final int total;
        final int nWarns;
        final int nAlarms;
        final Boolean clear;
        final int interval;

        AlertProfile(String alertId, String alertDesc, String alertCause, int total, int nWarns, int nAlarms, boolean clear, int interval) {
            this.alertId = alertId;
            this.alertDesc = alertDesc;
            this.alertCause = alertCause;
            this.total = total;
            this.nWarns = nWarns;
            this.nAlarms = nAlarms;
            this.clear = clear;
            this.interval = interval;
        }
    }
}

