/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.model.PlotData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusDataPersister
extends BatchPersister
implements StatusMessageListener,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    private static final DataDesc NULL_DESCRIPTION = new DataDesc();
    private static final long[] DEFAULT_TIME_BIN_WIDTH = new long[]{300000L, 1800000L};
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;
    private final Map<DataPath, DataDesc> map = new ConcurrentHashMap<DataPath, DataDesc>();
    private final Queue<RawData> statQueue = new ConcurrentLinkedQueue<RawData>();
    private final StatAccumulator statAccumulator = new StatAccumulator();
    private final Queue<MetaDataData> mdQueue = new ConcurrentLinkedQueue<MetaDataData>();
    private final MetaDataPersister mdAccumulator = new MetaDataPersister();

    public void start() {
        this.fac = StatusdbUtils.getSessionFactory(null);
        log.fine((Object)"Starting StatusPersister");
        Session sess = this.fac.openSession();
        Transaction tx = sess.beginTransaction();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            this.map.put(dd.getDataPath(), dd);
            log.fine((Object)("storing " + dd.getDataPath().getFullKey()));
            StatusDataPersister.getStatDescs(dd, sess);
        }
        tx.commit();
        sess.close();
        this.analizeDataMapIntegrity();
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusData.class).and(BusMessageFilterFactory.messageOrigin(null)));
        this.subsys.getScheduler().scheduleWithFixedDelay((Runnable)this.statAccumulator, 0L, 1L, TimeUnit.SECONDS);
        this.subsys.getScheduler().scheduleWithFixedDelay((Runnable)this.mdAccumulator, 0L, 1L, TimeUnit.SECONDS);
        this.subsys.getScheduler().scheduleWithFixedDelay((Runnable)this, 0L, 1L, TimeUnit.SECONDS);
    }

    public void onStatusMessage(StatusMessage s) {
        KeyValueDataList encodedData = (KeyValueDataList)s.getEncodedData();
        if (encodedData != null) {
            String source = s.getOriginAgentInfo().getName();
            for (KeyValueData d : encodedData) {
                KeyValueData.KeyValueDataType type = d.getType();
                if (type == KeyValueData.KeyValueDataType.KeyValueTrendingData) {
                    this.queueImmediateScalar(d.getTimestamp(), new DataPath(source, d.getKey()), d.getValue());
                    continue;
                }
                if (type == KeyValueData.KeyValueDataType.KeyValueMetaData) {
                    String metaPath = d.getKey();
                    int lastIndex = metaPath.lastIndexOf(47);
                    String metaname = metaPath.substring(lastIndex + 1);
                    String key = metaPath.replace("/" + metaname, "");
                    this.queueImmediateMetaData(d.getTimestamp(), new DataPath(source, key), metaname, (String)((Object)d.getValue()));
                    continue;
                }
                if (type != KeyValueData.KeyValueDataType.KeyValuePlotData) continue;
                PlotData plotData = new PlotData();
                plotData.setTime(d.getTimestamp());
                plotData.setPlotData((String)((Object)d.getValue()));
                this.addToQueue(new Object[]{plotData, new DataPath(source, d.getKey())});
            }
        }
    }

    private void queueImmediateMetaData(long tStamp, DataPath name, String metadata, String value) {
        MetaDataData md = new MetaDataData(tStamp);
        md.setName(metadata);
        md.setValue(value);
        this.addToQueue(new Object[]{md, name});
    }

    private void queueImmediateScalar(long tStamp, DataPath name, Object d) {
        log.debug((Object)("got update " + name));
        RawData data = new RawData();
        data.setTime(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).doubleValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).doubleValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).doubleValue()));
        } else if (d instanceof Long) {
            data.setDoubleData(Double.valueOf(((Long)d).doubleValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(new Object[]{data, name});
    }

    private void persistData(RawData data, DataPath name, Session sess) {
        if (data.getDoubleData() != null && Double.isNaN(data.getDoubleData())) {
            return;
        }
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null || dd == NULL_DESCRIPTION) {
            return;
        }
        data.setDataDesc(dd);
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        this.statQueue.add(data);
    }

    public StatAccumulator getStatAccumulator() {
        return this.statAccumulator;
    }

    private void persistMetadata(MetaDataData md, DataPath name, Session sess) {
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null || dd == NULL_DESCRIPTION) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        md.setDataDesc(dd);
        this.mdQueue.add(md);
    }

    private void persistPlotData(PlotData pd, DataPath name, Session sess) {
        DataDesc dd = this.getDataDescription(name, "plot", sess);
        if (dd == null || dd == NULL_DESCRIPTION) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        pd.setDataDesc(dd);
        sess.persist((Object)pd);
    }

    private DataDesc getDataDescription(DataPath key, String type, Session sess) {
        Query q = sess.getNamedQuery("findDataDesc").setString("agentName", key.getAgentName()).setString("dataName", key.getDataName());
        DataDesc dd = (DataDesc)q.uniqueResult();
        if (dd == null) {
            for (DataPath existingKey : this.map.keySet()) {
                if (StatusDataPersister.areDataNamesConsistent(existingKey.getFullKey(), key.getFullKey()) || this.map.get(existingKey) == NULL_DESCRIPTION) continue;
                log.warning((Object)("Cannot add data description for " + key + " as it's in conflict with " + existingKey));
                this.map.put(key, NULL_DESCRIPTION);
                return NULL_DESCRIPTION;
            }
            dd = new DataDesc();
            dd.setDataPath(key);
            dd.setDataType(type);
            sess.persist((Object)dd);
            log.debug((Object)("Adding default Data Description for " + key + ": " + dd.getId()));
            this.map.put(key, dd);
        }
        return dd;
    }

    public static List<StatDesc> getStatDescs(DataDesc dd, Session sess) {
        List stats = sess.getNamedQuery("findStatDesc").setEntity("dd", (Object)dd).setFlushMode(FlushMode.COMMIT).setCacheable(true).list();
        if (stats.isEmpty()) {
            for (long statInterval : DEFAULT_TIME_BIN_WIDTH) {
                StatDesc defaultSD = new StatDesc();
                defaultSD.setDataDesc(dd);
                defaultSD.setTimeBinWidth(statInterval);
                sess.persist((Object)defaultSD);
                stats.add(defaultSD);
                log.fine((Object)("Adding default statistical binning of " + statInterval + " milliseconds to " + dd.getDataPath()));
            }
        }
        return stats;
    }

    private void analizeDataMapIntegrity() {
        for (DataPath existingKey1 : this.map.keySet()) {
            for (DataPath existingKey2 : this.map.keySet()) {
                if (existingKey1.equals((Object)existingKey2) || StatusDataPersister.areDataNamesConsistent(existingKey1.getFullKey(), existingKey2.getFullKey())) continue;
                log.warning((Object)("Conflict for existing keys: " + existingKey1 + " and " + existingKey2));
            }
        }
    }

    static boolean areDataNamesConsistent(String name1, String name2) {
        if (name1.equals(name2)) {
            return true;
        }
        String[] array1 = name1.split("/");
        String[] array2 = name2.split("/");
        for (int i = 0; i < Math.min(array1.length, array2.length); ++i) {
            if (array1[i].equals(array2[i])) continue;
            return true;
        }
        return array1.length == array2.length;
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        Object toPersist = obj[0];
        DataPath name = (DataPath)obj[1];
        if (toPersist instanceof RawData) {
            this.persistData((RawData)toPersist, name, sess);
        } else if (toPersist instanceof MetaDataData) {
            this.persistMetadata((MetaDataData)toPersist, name, sess);
        } else if (toPersist instanceof PlotData) {
            this.persistPlotData((PlotData)toPersist, name, sess);
        } else if (toPersist != null) {
            sess.persist(toPersist);
        }
    }

    private class MetaDataPersister
    implements Runnable {
        private MetaDataPersister() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.fine((Object)"metadata accumulator starting");
            int n = 0;
            boolean empty = false;
            while (!empty) {
                Session sess = StatusDataPersister.this.getSessionFactory().openSession();
                try {
                    Transaction tx = sess.beginTransaction();
                    int i = 0;
                    while (i < 3000) {
                        MetaDataData md = (MetaDataData)StatusDataPersister.this.mdQueue.poll();
                        n = i++;
                        if (md == null) {
                            empty = i == 0;
                            break;
                        }
                        this.persistMetaData(md, sess);
                    }
                    if (!empty) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"metadata accumulator exception ", (Throwable)e);
                    StatusDataPersister.this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert("metadataPersister", e), AlertState.WARNING, LocalDBAlert.getFirstException(e));
                }
                finally {
                    if (sess.isOpen()) {
                        sess.close();
                    }
                }
                log.fine((Object)("metadata accumulator done, n=" + n));
            }
        }

        private void persistMetaData(MetaDataData md, Session sess) {
            Query q = sess.createQuery("from MetaDataData md where dataDesc.id = :id and name = :n and endTime <= 0");
            q.setParameter("id", (Object)md.getDataDesc().getId());
            q.setParameter("n", (Object)md.getName());
            MetaDataData oldMetaData = (MetaDataData)q.uniqueResult();
            if (oldMetaData != null) {
                oldMetaData.setEndTime(md.getStartTime());
            }
            sess.persist((Object)md);
        }
    }

    public class StatAccumulator
    implements Runnable {
        private final Map<StatDesc, StatData> statCache = new HashMap<StatDesc, StatData>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.fine((Object)"stat accumulator starting");
            int n = 0;
            boolean empty = false;
            while (!empty) {
                Session sess = StatusDataPersister.this.getSessionFactory().openSession();
                try {
                    Transaction tx = sess.beginTransaction();
                    int i = 0;
                    while (i < 3000) {
                        RawData data = (RawData)StatusDataPersister.this.statQueue.poll();
                        n = i++;
                        if (data == null) {
                            empty = i == 0;
                            break;
                        }
                        this.accumulateStatData(data, sess, new StatDesc[0]);
                    }
                    if (!empty) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"stat accumulator exception ", (Throwable)e);
                    StatusDataPersister.this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert("statdataPersister", e), AlertState.WARNING, LocalDBAlert.getFirstException(e));
                }
                finally {
                    if (sess.isOpen()) {
                        sess.close();
                    }
                }
                log.fine((Object)("stat accumulator done, n=" + n));
            }
        }

        public void accumulateStatData(RawData data, Session sess, StatDesc ... sds) {
            List<StatDesc> stats = StatusDataPersister.getStatDescs(data.getDataDesc(), sess);
            long dataTime = data.getTime();
            for (StatDesc stat : stats) {
                if (data.getDoubleData() == null) continue;
                long binWidth = stat.getTimeBinWidth();
                StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)binWidth, (long)dataTime, (Session)sess);
                StatData cachedStat = this.statCache.get(stat);
                if (cachedStat == null) {
                    StatData persistedSD = (StatData)sess.getNamedQuery("findStatData").setEntity("d", (Object)stat).setEntity("sti", (Object)sti).setCacheable(true).setFlushMode(FlushMode.COMMIT).uniqueResult();
                    if (persistedSD != null) {
                        log.fine((Object)("found existing stat data for " + persistedSD.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                        this.statCache.put(stat, persistedSD);
                        continue;
                    }
                    this.statCache.put(stat, new StatData(stat, data, sti));
                    continue;
                }
                if (cachedStat.getStatTimeInterval().equals((Object)sti)) {
                    cachedStat.accumulate(data);
                    continue;
                }
                log.fine((Object)"persisting cached statistical data ...");
                Iterator<Map.Entry<StatDesc, StatData>> it = this.statCache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<StatDesc, StatData> entry = it.next();
                    StatDesc key = entry.getKey();
                    StatData val = entry.getValue();
                    if (key.getTimeBinWidth() != sti.getBinWidth()) continue;
                    log.finest((Object)("persisting stat data " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + val.getStatDesc().getTimeBinWidth()));
                    try {
                        if (val.getId() > 0L) {
                            log.fine((Object)("merging : " + val.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                            sess.merge((Object)val);
                        } else {
                            sess.persist((Object)val);
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)("cannot persist " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " with tbw " + val.getStatTimeInterval().getStartTime() + ":" + val.getStatTimeInterval().getBinWidth()), (Throwable)ex);
                    }
                    it.remove();
                }
                log.fine((Object)"persisting cached statistical data done");
                this.statCache.put(stat, new StatData(stat, data, sti));
            }
        }

        public void flush(Session sess) {
            Iterator<Map.Entry<StatDesc, StatData>> it = this.statCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<StatDesc, StatData> entry = it.next();
                StatData val = entry.getValue();
                log.finest((Object)("persisting stat data " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + val.getStatDesc().getTimeBinWidth()));
                try {
                    if (val.getId() > 0L) {
                        log.fine((Object)("merging : " + val.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                        sess.merge((Object)val);
                    } else {
                        sess.persist((Object)val);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("cannot persist " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " with tbw " + val.getStatTimeInterval().getStartTime() + ":" + val.getStatTimeInterval().getBinWidth()), (Throwable)ex);
                }
                it.remove();
            }
        }
    }
}

