/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BatchPersister
implements Runnable,
ClearAlertHandler {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    private final String persisterName = this.getClass().getSimpleName();
    private static final int CONSECUTIVE_MAX_CAPACITY_LIMIT = 15;
    private static final String MAX_CAPACITY_ALERT_ID = "MaxCapacityAlert";
    private final Queue<Object[]> rq = new ConcurrentLinkedQueue<Object[]>();
    private final AlertService alertService;
    private int maxCapacityCount = 0;
    protected final SessionFactory fac;

    public BatchPersister(SessionFactory fac, AlertService as) {
        this.alertService = as;
        this.alertService.addClearAlertHandler((ClearAlertHandler)this);
        this.fac = fac;
    }

    public SessionFactory getSessionFactory() {
        return this.fac;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        if (alert.getAlertId().equals(this.persisterName + "_" + MAX_CAPACITY_ALERT_ID)) {
            this.maxCapacityCount = 0;
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Object[]> workingList = new ArrayList<Object[]>(1000);
        boolean empty = false;
        while (!empty) {
            for (int i = 0; i < 1000; ++i) {
                Object[] d = this.rq.poll();
                if (d == null) {
                    this.maxCapacityCount = 0;
                    break;
                }
                workingList.add(d);
                if (i != 999) continue;
                ++this.maxCapacityCount;
            }
            if (this.maxCapacityCount == 15) {
                this.alertService.raiseAlert(new Alert(this.persisterName + "_" + MAX_CAPACITY_ALERT_ID, this.persisterName + " running at full capacity"), AlertState.WARNING, "current queue size : " + this.rq.size());
                this.maxCapacityCount = 0;
            }
            if (workingList.isEmpty()) {
                empty = true;
                continue;
            }
            log.debug((Object)(this.persisterName + " start batch processing of " + workingList.size() + " entities."));
            Session sess = this.fac.openSession();
            sess.setFlushMode(FlushMode.COMMIT);
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                for (Object[] o : workingList) {
                    try {
                        this.persist(o, sess);
                    }
                    catch (Exception e) {
                        throw new Exception("Failed to persist object (" + o[1] + ") " + o[0], e);
                    }
                }
                tx.commit();
            }
            catch (Exception ex) {
                log.error((Object)("caught exception when persisting : " + ex), (Throwable)ex);
                try {
                    if (tx == null || tx.getStatus() != TransactionStatus.ACTIVE && tx.getStatus() != TransactionStatus.MARKED_ROLLBACK) continue;
                    tx.rollback();
                }
                catch (Exception rbEx) {
                    log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                }
            }
            finally {
                if (sess.isOpen()) {
                    sess.close();
                }
                workingList.clear();
            }
        }
        log.debug((Object)(this.getClass().getSimpleName() + " leaving batch processing loop"));
    }

    public void addToQueue(Object[] obj) {
        this.rq.add(obj);
    }

    public abstract void persist(Object[] var1, Session var2);
}

