/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.configdb.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.utilities.logging.Logger;

public class ConfigurationPersister
implements ConfigurationDAO,
AgentPresenceListener,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private final ConfigurationFacade facade;
    private final Map<String, Description> aliveDescriptions = new HashMap<String, Description>();
    private final Map<String, CountDownLatch> descriptionReady = new HashMap<String, CountDownLatch>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent s;
    private final BlockingQueue<Map.Entry<ConfigurationInfoData, StatusConfigurationInfo>> ciQueue = new ArrayBlockingQueue<Map.Entry<ConfigurationInfoData, StatusConfigurationInfo>>(1000);
    private final Thread statusConfigurationInfoSerializer;

    public ConfigurationPersister(Agent agent, SessionFactory fac) {
        this.s = agent;
        this.s.setAgentProperty("org.lsst.ccs.config.service", "true");
        this.facade = new ConfigurationFacade(new HibernateDAO(fac));
        this.statusConfigurationInfoSerializer = new Thread(new ConfigurationInfoPersister());
    }

    public void start() {
        this.statusConfigurationInfoSerializer.start();
    }

    public void shutdownNow() {
        this.statusConfigurationInfoSerializer.interrupt();
    }

    @Command
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDescription) throws ConfigurationServiceException {
        return this.facade.loadConfiguration(this.descriptionWaitAndGet(agentName), configDescription);
    }

    @Command
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        return this.facade.loadGlobalConfiguration(this.descriptionWaitAndGet(agentName), name, version);
    }

    @Command
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        return this.facade.findAvailableConfigurationsForCategory(this.descriptionWaitAndGet(agentName), category);
    }

    @Command
    public boolean isAvailable() {
        return true;
    }

    @Command
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return this.facade.registerConfiguration(this.descriptionWaitAndGet(agentName), configInfo, null);
    }

    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return null;
    }

    private Description descriptionWaitAndGet(String agentName) {
        try {
            this.descriptionReady.get(agentName).await();
            return this.aliveDescriptions.get(agentName);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot get description for " + agentName, ex);
        }
    }

    private void processFirstStatusConfigurationInfo(StatusConfigurationInfo sci, ConfigurationInfoData cid) {
        ConfigurationInfo ci = sci.getConfigurationInfo();
        String agentName = cid.getAgentDesc().getAgentName();
        try {
            Description desc = this.facade.registerDescription(cid.getAgentDesc(), ci.getAllParameterInfo());
            log.finest((Object)("registered description for " + agentName + " with id " + desc.getId()));
            log.finest((Object)("registering initial configuration info : " + ci.getConfigurationName() + " at " + sci.getTimeStamp()));
            this.facade.cleanupConfigurationRuns(desc, cid.getTime());
            this.facade.registerConfiguration(desc, ci, cid);
            this.aliveDescriptions.put(agentName, desc);
        }
        catch (Exception ex) {
            log.error((Object)"cannot register description or persist first ConfigurationInfo", (Throwable)ex);
        }
    }

    public void connecting(AgentInfo agent) {
        String remote = agent.getAgentProperty("org.lsst.ccs.config.remote");
        if ("true".equals(remote)) {
            log.finest((Object)("got connection event from " + agent.getName()));
            this.descriptionReady.put(agent.getName(), new CountDownLatch(1));
        }
    }

    public void disconnecting(AgentInfo agent) {
        log.finest((Object)("got disconnection event from " + agent.getName()));
        long time = System.currentTimeMillis();
        Description desc = this.aliveDescriptions.remove(agent.getName());
        if (desc != null) {
            this.facade.stopConfigurationRuns(desc, time);
        }
    }

    public void submit(ConfigurationInfoData data, StatusConfigurationInfo sci) {
        this.ciQueue.offer(new AbstractMap.SimpleEntry<ConfigurationInfoData, StatusConfigurationInfo>(data, sci));
    }

    private class ConfigurationInfoPersister
    implements Runnable {
        private ConfigurationInfoPersister() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Map.Entry e = (Map.Entry)ConfigurationPersister.this.ciQueue.take();
                    ConfigurationInfoData cid = (ConfigurationInfoData)e.getKey();
                    String name = cid.getAgentDesc().getAgentName();
                    StatusConfigurationInfo sci = (StatusConfigurationInfo)e.getValue();
                    Description desc = (Description)ConfigurationPersister.this.aliveDescriptions.get(name);
                    if (desc == null) {
                        ConfigurationPersister.this.processFirstStatusConfigurationInfo(sci, cid);
                        continue;
                    }
                    if (ConfigurationPersister.this.descriptionReady.get(name) != null) {
                        ((CountDownLatch)ConfigurationPersister.this.descriptionReady.get(name)).countDown();
                        continue;
                    }
                    log.fine((Object)("received  configuration state at : " + sci.getTimeStamp() + " : " + sci.getConfigurationInfo().getConfigurationName()));
                    ConfigurationPersister.this.facade.registerConfiguration((Description)ConfigurationPersister.this.aliveDescriptions.get(name), sci.getConfigurationInfo(), cid);
                }
            }
            catch (InterruptedException ex) {
                log.info((Object)"configuration info serializer thread interrupted", (Throwable)ex);
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

