/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.util.BuilderSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.groovy.GroovyComponentNode;
import org.lsst.ccs.description.groovy.GroovyConstructorInvoker;
import org.lsst.ccs.description.groovy.GroovyReferencePlaceHolder;
import org.lsst.ccs.utilities.logging.Logger;

class GroovyComponentBuilder
extends BuilderSupport {
    private final Map<String, ComponentNode> internalDictionary = new HashMap<String, ComponentNode>();

    GroovyComponentBuilder() {
    }

    @Override
    public void setParent(Object o, Object o1) {
        GroovyComponentNode parent = (GroovyComponentNode)o;
        parent.addChild((GroovyComponentNode)o1);
    }

    @Override
    public Object createNode(Object name) {
        throw new IllegalStateException("class missing for node " + name);
    }

    @Override
    public Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    @Override
    public Object createNode(Object name, Map attributes) {
        throw new IllegalStateException("class missing for node " + name);
    }

    @Override
    public Object createNode(Object name, Map attributes, Object value) {
        String key;
        if (attributes.containsKey("name")) {
            key = (String)attributes.get("name");
            if (!key.equals(name)) {
                Logger.getLogger((String)"org.lsst.ccs.description.groovy").warn((Object)("the component name will be " + key + " instead of " + name + ". This behaviour should not be used as it will be discontinued. See LSSTCCS-945"));
            }
        } else {
            key = (String)name;
        }
        if (this.getInternalDictionary().containsKey(key)) {
            throw new IllegalArgumentException("node with name : " + key + " already exists");
        }
        try {
            GroovyComponentNode node = new GroovyComponentNode(this.getCurrentNode(), key, attributes, (Class)value);
            this.getInternalDictionary().put(key, node);
            return node;
        }
        catch (Exception ex) {
            throw new RuntimeException("at node : " + name + ": " + ex.getMessage(), ex);
        }
    }

    protected GroovyComponentNode getCurrentNode() {
        GroovyComponentNode current = (GroovyComponentNode)this.getCurrent();
        return current;
    }

    protected Map<String, ComponentNode> getInternalDictionary() {
        return this.internalDictionary;
    }

    @Override
    public void nodeCompleted(Object parent, Object node) {
        GroovyComponentNode gNode = (GroovyComponentNode)node;
        try {
            gNode.attributes = this.resolveReferencesInAttributes(gNode.attributes);
            Object component = new GroovyConstructorInvoker().invokeConstructor(gNode.getCls(), gNode.getAttributes());
            gNode.setComponent(component);
        }
        catch (Exception ex) {
            throw new RuntimeException("At node : " + gNode.getKey() + " : " + ex.getMessage(), ex);
        }
    }

    private Map resolveReferencesInAttributes(Map attributes) {
        HashMap newAttributes = new HashMap();
        for (Object key : attributes.keySet()) {
            Object value = attributes.get(key);
            if (value instanceof GroovyReferencePlaceHolder) {
                ComponentNode compNode = this.getInternalDictionary().get(((GroovyReferencePlaceHolder)value).getReference());
                if (compNode != null) {
                    value = compNode.getComponent();
                } else {
                    throw new RuntimeException("null reference associated to " + key);
                }
            }
            newAttributes.put(key, value);
        }
        return newAttributes;
    }
}

