/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationHandlerSet {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private String descriptionName;
    private final Map<String, ConfigurationHandler> componentParameterHandlers = new LinkedHashMap<String, ConfigurationHandler>();
    private final Map<String, CategoryHandler> parametersByCategories = new HashMap<String, CategoryHandler>();
    private ConfigurationView initialView;
    private final Set<String> categories = new HashSet<String>();

    public boolean addConfigurationHandlerForObject(String componentName, Object component) {
        ConfigurationHandler handler = ConfigurationHandlerBuilder.buildParameterSetterFromObject(componentName, component);
        if (handler == null) {
            return false;
        }
        this.componentParameterHandlers.put(componentName, handler);
        for (ConfigurationParameterHandler cph : handler.getConfigurationParameterHandlers()) {
            String category = cph.getCategory();
            CategoryHandler set = this.parametersByCategories.get(category);
            if (set == null) {
                set = new CategoryHandler(category);
                this.parametersByCategories.put(category, set);
            }
            set.addParameterHandler(cph);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.componentParameterHandlers.isEmpty();
    }

    public ConfigurationInfo initialize(String descriptionName) {
        return this.initialize(descriptionName, new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories)));
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView) {
        this.descriptionName = descriptionName;
        this.categories.addAll(this.getCategorySet());
        this.initialView = new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories));
        this.initialView.putAll(this.getLiveConfigurationView());
        this.initialView.putAll(safeView);
        try {
            this.loadCategories(safeView);
            for (Map.Entry<ParameterPath, String> pp : this.initialView.getAsParameterPathMap().entrySet()) {
                if (!pp.getValue().equals("_null_")) continue;
                log.warn((Object)("parameter " + pp.getKey() + " has not been assigned a safe non null value"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("could not load safe configuration : " + ex.getMessage(), ex);
        }
        HashMap<String, Boolean> hasCatChangedMap = new HashMap<String, Boolean>();
        for (String cat : this.categories) {
            hasCatChangedMap.put(cat, false);
        }
        ArrayList<ConfigurationParameterInfo> parmsInfoList = new ArrayList<ConfigurationParameterInfo>();
        for (ConfigurationHandler ch : this.componentParameterHandlers.values()) {
            for (ConfigurationParameterHandler cph : ch.getConfigurationParameterHandlers()) {
                ParameterPath pp = new ParameterPath(cph.getComponentName(), cph.getParameterName());
                parmsInfoList.add(new ConfigurationParameterInfo(pp.toString(), cph.getCategory(), cph.getType().getTypeName(), cph.isFinal(), this.initialView.getPathValue(pp), this.initialView.getPathValue(pp), false, cph.getDescription()));
            }
        }
        return new ConfigurationInfo(ConfigurationState.INITIAL_SAFE, descriptionName, null, this.initialView.getConfigurationDescription().getCategoryTags(), this.initialView.getConfigurationDescription().getCategoryVersions(), hasCatChangedMap, parmsInfoList, Collections.EMPTY_LIST);
    }

    private ConfigurationHandler getParameterSet(String componentName) {
        ConfigurationHandler res = this.componentParameterHandlers.get(componentName);
        if (res == null) {
            throw new IllegalArgumentException("no such component : " + componentName);
        }
        return res;
    }

    private CategoryHandler getCategoryHandler(String category) {
        CategoryHandler res = this.parametersByCategories.get(category);
        if (res == null) {
            log.info((Object)("no such category : " + category));
        }
        return res;
    }

    public boolean isParameterConfigurable(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterConfigurable(parameterName);
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.parametersByCategories.keySet());
    }

    public ConfigurationView loadCategories(ConfigurationView cv) {
        ConfigurationDescription configDesc = cv.getConfigurationDescription();
        this.dropAllSubmittedChanges();
        for (Map.Entry<ParameterPath, String> entry : cv.getAsParameterPathMap().entrySet()) {
            ParameterPath parm = entry.getKey();
            if (this.isParameterConfigurable(parm.getComponentName(), parm.getParameterName())) {
                this.submitChange(parm.getComponentName(), parm.getParameterName(), entry.getValue());
                continue;
            }
            log.info((Object)("ignoring : " + parm));
        }
        for (String category : configDesc.getCategoryTags().keySet()) {
            CategoryHandler ch = this.getCategoryHandler(category);
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                String parameterName;
                String componentName = cph.getComponentName();
                if (cv.containsPath(new ParameterPath(componentName, parameterName = cph.getParameterName()))) continue;
                this.submitChange(componentName, parameterName, this.initialView.getPathValue(new ParameterPath(componentName, parameterName)));
            }
        }
        return this.commitBulkChange(configDesc);
    }

    public void dropAllSubmittedChanges() {
        this.componentParameterHandlers.values().stream().forEach(ConfigurationHandler::dropSubmittedChanges);
    }

    public void dropSubmittedChangesForComponent(String name) {
        this.getParameterSet(name).dropSubmittedChanges();
    }

    public Map<String, String> getSubmittedChangesForComponent(String name) {
        return this.getParameterSet(name).getSubmittedChanges().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            Map<String, String> submittedChanges = this.getSubmittedChangesForComponent(entry.getKey());
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap<String, String>(submittedChanges));
        }
        return res;
    }

    public void submitChange(String componentName, String parameterName, Object value) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter : " + componentName + "//" + parameterName + " : ignored"));
        } else {
            this.getParameterSet(componentName).submitChange(parameterName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit) {
        ConfigurationView submittedChanges;
        ConfigurationView before;
        block14: {
            before = this.getLiveConfigurationView();
            submittedChanges = new ConfigurationView();
            for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
                entry.getValue().trimSubmittedChanges();
                for (Map.Entry<String, String> e : entry.getValue().getSubmittedChanges().entrySet()) {
                    submittedChanges.putParameterValue(entry.getKey(), e.getKey(), e.getValue());
                }
            }
            log.fine((Object)("processing the following submitted changes :" + submittedChanges));
            BulkValidationException excThrown = null;
            try {
                for (ConfigurationHandler configurationHandler : this.componentParameterHandlers.values()) {
                    configurationHandler.invokeValidateBulkChange(ConfigurationDescription.safeConfiguration(this.categories).equals(categoriesToCommit));
                }
            }
            catch (Exception exception) {
                excThrown = new BulkValidationException(exception);
                return excThrown;
            }
            finally {
                ConfigurationView configurationView = this.getLiveConfigurationView();
                ConfigurationView configurationView2 = before.diff(configurationView);
                if (!configurationView2.isEmpty()) {
                    this.dropAllSubmittedChanges();
                    Set<ParameterPath> suspect = configurationView2.getAsParameterPathMap().keySet();
                    throw new BulkSettingException("some parameters have been modified during the validation step : " + suspect, excThrown);
                }
                if (excThrown == null) break block14;
                throw excThrown;
            }
        }
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            ConfigurationHandler ch = entry.getValue();
            try {
                ch.invokeSetParameters(before.getValuesForComponent(entry.getKey()));
            }
            catch (Exception ex) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException(ex.getMessage(), ex);
            }
        }
        ConfigurationView configurationView = this.getLiveConfigurationView();
        ConfigurationView configurationView3 = before.diff(configurationView);
        for (Map.Entry<ParameterPath, String> pathVal : configurationView3.getAsParameterPathMap().entrySet()) {
            ParameterPath path = pathVal.getKey();
            if (!submittedChanges.containsPath(path)) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException("the parameter " + path + " was not supposed to change from " + before.getPathValue(path) + " to " + pathVal.getValue());
            }
            if (submittedChanges.getPathValue(path).equals(pathVal.getValue())) continue;
            this.dropAllSubmittedChanges();
            throw new BulkSettingException("wrong value for parameter : " + path.toString() + ", expected : " + submittedChanges.getPathValue(path) + ", actual : " + pathVal.getValue());
        }
        this.dropAllSubmittedChanges();
        configurationView.setConfigurationDescription(categoriesToCommit);
        return configurationView;
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter " + new ParameterPath(componentName, parameterName)));
            return new ConfigurationView();
        }
        Map<String, Map<String, String>> previousChanges = this.getAllSubmittedChanges();
        this.dropAllSubmittedChanges();
        this.submitChange(componentName, parameterName, value);
        ConfigurationView view = this.commitBulkChange(null);
        this.dropAllSubmittedChanges();
        for (Map.Entry<String, Map<String, String>> entry : previousChanges.entrySet()) {
            String comp = entry.getKey();
            for (Map.Entry<String, String> e : entry.getValue().entrySet()) {
                String parmName = e.getKey();
                String parmVal = e.getValue();
                this.submitChange(comp, parmName, parmVal);
            }
        }
        return view;
    }

    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.getParameterSet(componentName).getCurrentValues(categorySet).entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public ConfigurationView getLiveConfigurationView() {
        ConfigurationView res = new ConfigurationView();
        for (String compName : this.componentParameterHandlers.keySet()) {
            res.putValuesForComponent(compName, this.getCurrentValuesForComponent(compName, this.categories));
        }
        return res;
    }
}

