/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.trendserver;

import java.net.NetworkInterface;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.utilities.logging.Logger;

public class RestServerAgent
extends Agent {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.trendserver");
    private final RestServer rs = new RestServer();
    private final String hostAddr;

    public RestServerAgent() throws Exception {
        super("rest-server", AgentInfo.AgentType.SERVICE);
        this.rs.start();
        NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());
        if (ne.getInterfaceAddresses().size() > 0) {
            this.hostAddr = ne.getInterfaceAddresses().get(0).getAddress().getHostAddress();
            log.info((Object)("trend server accessible through : " + this.hostAddr));
        } else {
            log.warn((Object)"cannot determine which network address to transmit");
            this.hostAddr = null;
        }
        this.setAgentProperty("rest-service-addr", this.hostAddr);
        this.setAgentProperty("rest-service-port", "8080");
        this.setAgentProperty("rest-service-entrypoint", "/rest/data");
    }
}

