/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.localdb.configdb.ConfigurationServerModule;
import org.lsst.ccs.localdb.configdb.ConfigurationServiceImpl;
import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.DBInterface;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ConfigurationServerSystem
extends Subsystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    ConfigurationServerModule serverModule;
    private final StatusMessageListener bootStatusListener = s -> {
        String initiatorName = s.getOriginAgentInfo().getName();
    };

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer", AgentInfo.AgentType.SERVICE);
        this.facade = facade;
        this.service = new ConfigurationServiceImpl(facade);
        this.serverModule = new ConfigurationServerModule(this.service);
        this.getMessagingAccess().addStatusMessageListener(this.bootStatusListener);
    }

    public static void main(String[] args) throws Exception {
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false");
        String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
        DBInterface dao = (DBInterface)Class.forName(clazzName).newInstance();
        ConfigurationFacade facade = new ConfigurationFacade(dao);
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
    }
}

