/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.rmi.Naming;
import java.util.List;
import org.lsst.ccs.localdb.configdb.ConfigurationService;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.Factories;
import org.lsst.ccs.localdb.configdb.model.ParameterBase;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.PathObject;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;

public class TztRMIClient1 {
    public static void main(String[] args) throws Exception {
        ConfigurationService facade = (ConfigurationService)Naming.lookup("rmi://localhost/config_server");
        SubsystemDescription subsystemDescription = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        System.out.println("---> registering a subsystem");
        subsystemDescription = facade.registerSubsystemDescription(subsystemDescription).getResult();
        System.out.println("side effect -> id is : " + subsystemDescription.getId());
        long oldID = subsystemDescription.getId();
        System.out.println("---> now trying to re-register the same object (idempotent)");
        subsystemDescription = facade.registerSubsystemDescription(subsystemDescription).getResult();
        System.out.println("should be a ghost ? : " + subsystemDescription.getId());
        SubsystemDescription anotherDescription = Factories.createSubsystemDescriptionCopy((SubsystemDescription)subsystemDescription);
        System.out.println("---> registering a copy subsystem");
        anotherDescription = facade.registerSubsystemDescription(anotherDescription).getResult();
        System.out.println("new id is : " + anotherDescription.getId());
        System.out.println("---> getting the ghost subsystem");
        String request = "from GhostSubsystemDescription where id = '" + oldID + "'";
        List listGhosts = facade.simpleHQLRequest(request);
        SubsystemDescription ghost = (SubsystemDescription)listGhosts.get(0);
        System.out.println("history : " + ghost + "begin date=" + ghost.getStartTimestamp() + "| end date=" + ghost.getEndTimestamp());
        System.out.println("---> getting the ghost subsystem through previous");
        SubsystemDescription anOldOne = facade.getPrevious(anotherDescription);
        System.out.println("old id is : " + anOldOne.getId());
        System.out.println("---> registering a profile");
        ConfigProfile profile1 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        profile1 = facade.registerConfigProfile(profile1).getResult();
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        System.out.println("---> registering another profile");
        ConfigProfile profile2 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        profile2 = facade.registerConfigProfile(profile2).getResult();
        System.out.println(" registered profile :" + profile2 + " --> " + profile2.getSubsystemDescription());
        System.out.println("---> re-registering a profile (idempotent)");
        profile1 = facade.registerConfigProfile(profile1).getResult();
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        System.out.println("---> registering a copy profile");
        ConfigProfile profile3 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        profile3 = facade.registerConfigProfile(profile3).getResult();
        System.out.println(" registered profile :" + profile3 + " --> " + profile3.getSubsystemDescription());
        System.out.println("---> deprecates the copy profile");
        facade.deprecateConfigProfile("mySubsystem", "", "profile1", "tag2");
        System.out.println("---> deprecates the subsystem description");
        facade.deprecateSubsystemDescription("mySubsystem", "");
        List list = facade.simpleHQLRequest("from PastConfigProfile");
        for (Object obj : list) {
            ConfigProfile profile = (ConfigProfile)obj;
            System.out.println("\tdeprecated:" + profile + "subsEnddate =" + profile.getSubsystemDescription().getEndTimestamp());
        }
        System.out.println("---> registering a profile with a deprecated  subsystem: " + subsystemDescription);
        try {
            ConfigProfile profile4 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"", (String)"profile1");
            System.err.println(" test failed: config profile created with deprecated object" + subsystemDescription);
            profile4 = facade.registerConfigProfile(profile4).getResult();
            System.err.println(" test failed: illegal creation of configProfile" + subsystemDescription);
        }
        catch (Exception exc) {
            System.out.println("test ok not created :" + exc);
        }
        System.out.println("---> a new subsystem description with parameters");
        SubsystemDescription subsystemDescription3 = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        ParameterBase base1 = new ParameterBase("component", "", "param1", "java.lang.String", "");
        ParameterBase base2 = new ParameterBase("component", "", "param2", "java.lang.Integer", "100");
        ParameterBase base3 = new ParameterBase("component", "", "param3", "java.lang.Double", "-0.1");
        ParameterDescription description1 = Factories.createParameterDescription((ParameterBase)base1, (String)"descr", (String)"p1", (String)"", (int)0);
        ParameterDescription description2 = Factories.createParameterDescription((ParameterBase)base2, (String)"descr", (String)"p2", (String)"", (int)0);
        ParameterDescription description3 = Factories.createParameterDescription((ParameterBase)base3, (String)"descr", (String)"p3", (String)"", (int)0);
        subsystemDescription3.addParameterDescriptions(new ParameterDescription[]{description1, description2, description3});
        subsystemDescription3 = facade.registerSubsystemDescription(subsystemDescription3).getResult();
        System.out.println("registered subsystem : " + subsystemDescription3);
        description1 = subsystemDescription3.fetch((PathObject)description1);
        description2 = subsystemDescription3.fetch((PathObject)description2);
        description3 = subsystemDescription3.fetch((PathObject)description3);
        System.out.println("---> a new profile with parameters");
        ConfigProfile profile5 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription3, (String)"", (String)"profile1");
        ParameterConfiguration config1 = Factories.createParameterConfiguration((ParameterDescription)description1, (String)"");
        ParameterConfiguration config2 = Factories.createParameterConfiguration((ParameterDescription)description2, (String)"400");
        ParameterConfiguration config3 = Factories.createParameterConfiguration((ParameterDescription)description3, (String)"0.0");
        try {
            profile5.addParameterConfigurations(new ParameterConfiguration[]{config1});
            System.err.println("TEST FAILED: illegal level");
        }
        catch (Exception exc) {
            System.out.println("TEST OK : level inconsistency detected :" + exc);
        }
        profile5.addParameterConfigurations(new ParameterConfiguration[]{config2, config3});
        System.out.println("paramconfig 2: " + config2);
        System.out.println("subsystem references :" + subsystemDescription3);
        profile5 = facade.registerConfigProfile(profile5).getResult();
        System.out.println("registered profile : " + profile5);
        System.out.println("---> Deprecating a complete subsystem");
        facade.deprecateSubsystemDescription("mySubsystem", "");
        List list1 = facade.simpleHQLRequest("from PastParameterConfiguration");
        for (Object obj : list1) {
            System.out.println("\t deprecated configuration :" + obj);
        }
        facade.deprecateSubsystemDescription("mySubsystem", "no Tag");
        System.out.println("THE END");
    }
}

