/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.util.List;
import org.lsst.ccs.localdb.configdb.dao.HibernateDAO;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.DBInterface;
import org.lsst.ccs.localdb.configdb.model.DeprecationListener;
import org.lsst.ccs.localdb.configdb.model.Factories;
import org.lsst.ccs.localdb.configdb.model.GhostSubsystemDescription;
import org.lsst.ccs.localdb.configdb.model.ParameterBase;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;

public class TztIDlifeCycle {
    public static void main(String[] args) throws Exception {
        HibernateDAO dao = new HibernateDAO();
        ConfigurationFacade facade = new ConfigurationFacade((DBInterface)dao);
        facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                System.out.println(".........deprecating subsystem description : " + description);
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                System.out.println(".........deprecating config profile : " + profile);
            }
        });
        SubsystemDescription subsystemDescription = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        System.out.println("---> registering a subsystem");
        facade.registerSubsystemDescription(subsystemDescription);
        System.out.println("side effect -> id is : " + subsystemDescription.getId());
        long oldID = subsystemDescription.getId();
        System.out.println("---> now trying to re-register the same object (idempotent)");
        facade.registerSubsystemDescription(subsystemDescription);
        System.out.println("id is : " + subsystemDescription.getId());
        SubsystemDescription anotherDescription = Factories.createSubsystemDescriptionCopy((SubsystemDescription)subsystemDescription);
        System.out.println("---> registering a copy subsystem");
        facade.registerSubsystemDescription(anotherDescription);
        System.out.println("new id is : " + anotherDescription.getId());
        System.out.println("---> getting the ghost subsystem");
        dao.begin();
        GhostSubsystemDescription ghost = dao.getGhostDescription(oldID);
        dao.end();
        System.out.println("history : " + ghost + "begin date=" + ghost.getStartTimestamp() + "| end date=" + ghost.getEndTimestamp());
        System.out.println("---> getting the ghost subsystem through previous");
        SubsystemDescription anOldOne = facade.getPrevious(anotherDescription);
        System.out.println("old id is : " + anOldOne.getId());
        System.out.println("---> registering a profile");
        ConfigProfile profile1 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        facade.registerConfigProfile(profile1);
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        System.out.println("---> registering another profile");
        ConfigProfile profile2 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        facade.registerConfigProfile(profile2);
        System.out.println(" registered profile :" + profile2 + " --> " + profile2.getSubsystemDescription());
        System.out.println("---> re-registering a profile (idempotent)");
        facade.registerConfigProfile(profile1);
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        System.out.println("---> registering a copy profile");
        ConfigProfile profile3 = Factories.createRawConfigProfile((SubsystemDescription)anotherDescription, (String)"", (String)"profile1");
        facade.registerConfigProfile(profile3);
        System.out.println(" registered profile :" + profile3 + " --> " + profile3.getSubsystemDescription());
        System.out.println("---> deprecates the copy profile");
        profile2 = facade.deprecateConfigProfile("mySubsystem", "", "profile1", "tag2");
        System.out.println("---> deprecates the subsystem description");
        subsystemDescription = facade.deprecateSubsystemDescription("mySubsystem", "");
        dao.begin();
        List list = dao.simpleHQLRequest("from PastConfigProfile");
        dao.end();
        for (Object obj : list) {
            ConfigProfile profile = (ConfigProfile)obj;
            System.out.println("\tdeprecated:" + profile + "subsEnddate =" + profile.getSubsystemDescription().getEndTimestamp());
        }
        System.out.println("---> registering a profile with a deprecated  subsystem");
        try {
            ConfigProfile profile4 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"", (String)"profile1");
            System.err.println(" test failed: config profile created with deprecated object" + subsystemDescription);
            facade.registerConfigProfile(profile4);
            System.err.println(" test failed: illegal creation of configProfile" + subsystemDescription);
        }
        catch (Exception exc) {
            System.out.println("test ok not created :" + exc);
        }
        System.out.println("---> a new subsystem description with parameters");
        SubsystemDescription subsystemDescription3 = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        ParameterBase base1 = new ParameterBase("component", "", "param1", "java.lang.String", "");
        ParameterBase base2 = new ParameterBase("component", "", "param2", "java.lang.Integer", "100");
        ParameterBase base3 = new ParameterBase("component", "", "param3", "java.lang.Double", "-0.1");
        ParameterDescription description1 = Factories.createParameterDescription((ParameterBase)base1, (String)"descr", (String)"p1", (String)"", (int)0);
        ParameterDescription description2 = Factories.createParameterDescription((ParameterBase)base2, (String)"descr", (String)"p2", (String)"", (int)0);
        ParameterDescription description3 = Factories.createParameterDescription((ParameterBase)base3, (String)"descr", (String)"p3", (String)"", (int)0);
        subsystemDescription3.addParameterDescriptions(new ParameterDescription[]{description1, description2, description3});
        facade.registerSubsystemDescription(subsystemDescription3);
        System.out.println("registered subsystem : " + subsystemDescription3);
        System.out.println("---> a new profile with parameters");
        ConfigProfile profile5 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription3, (String)"", (String)"profile1");
        ParameterConfiguration config1 = Factories.createParameterConfiguration((ParameterDescription)description1, (String)"String");
        ParameterConfiguration config2 = Factories.createParameterConfiguration((ParameterDescription)description2, (String)"100");
        ParameterConfiguration config3 = Factories.createParameterConfiguration((ParameterDescription)description3, (String)"10.0");
        try {
            profile5.addParameterConfigurations(new ParameterConfiguration[]{config1});
            System.err.println("TEST FAILED: illegal level");
        }
        catch (Exception exc) {
            System.out.println("TEST OK : level inconsistency detected :" + exc);
        }
        profile5.addParameterConfigurations(new ParameterConfiguration[]{config2, config3});
        facade.registerConfigProfile(profile5);
        System.out.println("registered profile : " + profile5);
        System.out.println("---> Deprecating a complete subsystem");
        facade.deprecateSubsystemDescription("mySubsystem", "");
        dao.begin();
        List list1 = dao.simpleHQLRequest("from PastParameterConfiguration");
        for (Object obj : list1) {
            System.out.println("\t deprecated configuration :" + obj);
        }
        dao.end();
        facade.deprecateSubsystemDescription("mySubsystem", "no Tag");
        System.out.println("THE END");
    }
}

