/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.util.Date;
import org.lsst.ccs.localdb.configdb.dao.HibernateDAO;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.DBInterface;
import org.lsst.ccs.localdb.configdb.model.DeprecationListener;
import org.lsst.ccs.localdb.configdb.model.Factories;
import org.lsst.ccs.localdb.configdb.model.ParameterBase;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;

public class TztEngineeringMode1 {
    public static void main(String[] args) throws Exception {
        HibernateDAO dao = new HibernateDAO();
        ConfigurationFacade facade = new ConfigurationFacade((DBInterface)dao);
        facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                System.out.println(".........deprecating subsystem description : " + description);
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                System.out.println(".........deprecating config profile : " + profile);
            }
        });
        SubsystemDescription subsystemDescription = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        ParameterBase base2 = new ParameterBase("component", "", "param2", "java.lang.Integer", "100");
        ParameterBase base3 = new ParameterBase("component", "", "param3", "java.lang.Double", "-0.1");
        ParameterDescription description2 = Factories.createParameterDescription((ParameterBase)base2, (String)"descr", (String)"p2", (String)"", (int)0);
        ParameterDescription description3 = Factories.createParameterDescription((ParameterBase)base3, (String)"descr", (String)"p3", (String)"", (int)0);
        subsystemDescription.addParameterDescriptions(new ParameterDescription[]{description2, description3});
        System.out.println("---> registering a subsystem");
        facade.registerSubsystemDescription(subsystemDescription);
        ConfigProfile profile1 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"", (String)"profile1");
        ParameterConfiguration config2 = Factories.createParameterConfiguration((ParameterDescription)description2, (String)"200");
        ParameterConfiguration config3 = Factories.createParameterConfiguration((ParameterDescription)description3, (String)"0.1");
        profile1.addParameterConfigurations(new ParameterConfiguration[]{config2, config3});
        facade.registerConfigProfile(profile1);
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        facade.registerRun("mySubsystem", "profile1", "tag", System.currentTimeMillis());
        ConfigProfile engProfile = Factories.copyProfile((ConfigProfile)profile1, (String)"engProfile1");
        facade.registerConfigProfile(engProfile);
        facade.registerRun("mySubsystem", "engProfile1", "engineering", System.currentTimeMillis());
        Thread.sleep(10L);
        long time = System.currentTimeMillis();
        System.out.println("TIME -> " + time);
        ConfigProfile taggedVersion = Factories.copyProfile((ConfigProfile)engProfile, (String)"high wind");
        facade.registerConfigProfile(taggedVersion);
        facade.registerRun("mySubsystem", "profile2", "high wind", System.currentTimeMillis());
        System.out.println("modified value should be 400 : " + taggedVersion.getValue(base2.getPath()));
        System.out.println(" engineering profile" + engProfile);
        System.out.println(" new tagged profile" + taggedVersion);
        ConfigProfile running = facade.getConfigRunningAt("mySubsystem", "", "", time);
        if (running != null) {
            String aVal = running.getValue("component//param2");
            System.out.println("at " + new Date(time) + "value was " + aVal);
        } else {
            System.out.println("value not found");
        }
    }
}

