/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.rmi.RemoteException;
import java.util.List;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.localdb.configdb.ConfigurationService;
import org.lsst.ccs.localdb.configdb.DescriptionDeprecationEvent;
import org.lsst.ccs.localdb.configdb.DescriptionResult;
import org.lsst.ccs.localdb.configdb.ProfileDeprecationEvent;
import org.lsst.ccs.localdb.configdb.ProfileResult;
import org.lsst.ccs.localdb.configdb.model.AConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.DBInterface;
import org.lsst.ccs.localdb.configdb.model.DeprecationListener;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.PersistenceLayerException;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;

public class ConfigurationServiceImpl
implements ConfigurationService {
    ConfigurationFacade facade;
    public static ConfigurationServiceImpl ON_DATABASE;

    public ConfigurationServiceImpl(ConfigurationFacade facade) {
        this.facade = facade;
    }

    public ConfigurationFacade getFacade() {
        return this.facade;
    }

    @Override
    public synchronized DescriptionResult registerSubsystemDescription(SubsystemDescription newDescription) throws RemoteException {
        final DescriptionResult res = new DescriptionResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                res.setDescriptionDeprecationEvent(new DescriptionDeprecationEvent(description, ""));
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                res.addProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            SubsystemDescription description = this.facade.registerSubsystemDescription(newDescription);
            res.setResult(description);
            return res;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server registration fail", e);
        }
    }

    @Override
    public synchronized DescriptionResult deprecateSubsystemDescription(String subsystemName, String tag) throws RemoteException {
        final DescriptionResult res = new DescriptionResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                res.setDescriptionDeprecationEvent(new DescriptionDeprecationEvent(description, ""));
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                res.addProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            SubsystemDescription deprecated = this.facade.deprecateSubsystemDescription(subsystemName, tag);
            res.setResult(deprecated);
            DescriptionResult descriptionResult = res;
            return descriptionResult;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server deprecation fail", e);
        }
        finally {
            this.facade.setDeprecationListener(null);
        }
    }

    @Override
    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws RemoteException {
        try {
            return this.facade.getActiveSubsystemDescription(name, tag);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("description query", e);
        }
    }

    @Override
    public synchronized ProfileResult registerConfigProfile(ConfigProfile newProfile) throws RemoteException {
        final ProfileResult res = new ProfileResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                res.setProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            ConfigProfile profile = this.facade.registerConfigProfile(newProfile);
            res.setResult(profile);
            return res;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server registration fail", e);
        }
    }

    @Override
    public ProfileResult registerConfiguration(String subsystemName, String categoryName, String configurationName, String tag, String user, int level) throws RemoteException {
        SubsystemDescription description = this.getActiveSubsystemDescription(subsystemName, tag);
        AConfigProfile profile = this.facade.getActiveConfigProfile(subsystemName, description.getTag(), configurationName, categoryName);
        return this.registerConfigProfile((ConfigProfile)profile);
    }

    @Override
    public synchronized ProfileResult deprecateConfigProfile(String subsystemName, String descriptionName, String name, String tag) throws RemoteException {
        final ProfileResult res = new ProfileResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                res.setProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            ConfigProfile deprecated = this.facade.deprecateConfigProfile(subsystemName, descriptionName, name, tag);
            res.setResult(deprecated);
            ProfileResult profileResult = res;
            return profileResult;
        }
        catch (PersistenceLayerException exc) {
            throw new RemoteException("server deprecation fail", exc);
        }
        finally {
            this.facade.setDeprecationListener(null);
        }
    }

    @Override
    public ConfigProfile getActiveConfigProfile(String subsystemName, String descriptionName, String name, String tag) throws RemoteException {
        try {
            return this.facade.getActiveConfigProfile(subsystemName, descriptionName, name, tag);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("configuration query", e);
        }
    }

    @Override
    public ParameterConfiguration modifyParmConf(ParameterConfiguration engineeringModeParm) throws RemoteException {
        try {
            ParameterConfiguration res = this.facade.engineerParmConfig(engineeringModeParm);
            return res;
        }
        catch (PersistenceLayerException exc) {
            throw new RemoteException("parameter configuration fail :", exc);
        }
    }

    @Override
    public ConfigProfile getConfigRunningAt(String subsystemName, String descriptionName, String category, long date) throws RemoteException {
        try {
            return this.facade.getConfigRunningAt(subsystemName, descriptionName, category, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public String getActiveValueAt(String subsystemName, String descriptionName, String category, String parameterPath, long date) throws RemoteException {
        try {
            return this.facade.getActiveValueAt(subsystemName, descriptionName, category, parameterPath, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getConfigValidAt(String subsystemName, String name, String tag, long date) throws RemoteException {
        try {
            return this.facade.getConfigValidAt(subsystemName, name, tag, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public String getValueValidAt(String subsystemName, String profileName, String profileTag, String parameterPath, long date) throws RemoteException {
        try {
            return this.facade.getValueValidAt(subsystemName, profileName, profileTag, parameterPath, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getPrevious(ConfigProfile current) throws RemoteException {
        try {
            return this.facade.getPrevious(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getNext(ConfigProfile current) throws RemoteException {
        try {
            return this.facade.getNext(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public SubsystemDescription getPrevious(SubsystemDescription current) throws RemoteException {
        try {
            return this.facade.getPrevious(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) throws RemoteException {
        try {
            return this.facade.simpleHQLRequest(hqlString);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server request fail", e);
        }
    }

    static {
        String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
        DBInterface dao = null;
        try {
            dao = (DBInterface)Class.forName(clazzName).newInstance();
            ON_DATABASE = new ConfigurationServiceImpl(new ConfigurationFacade(dao));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

