/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;

public class SubsystemBoot {
    static String descriptionName;
    static String configurationFileName;
    static String subsystemAlias;
    static String subsystemClassName;

    public static void main(String[] args) throws Exception {
        Agent a;
        SubsystemBoot.parseArgsCLI(args);
        if (descriptionName != null) {
            if (descriptionName.endsWith(".xml")) {
                throw new IllegalArgumentException("Spring no longer supported");
            }
            a = BootUtils.getSubsystemFromFile(descriptionName, configurationFileName, subsystemAlias);
        } else if (subsystemClassName != null) {
            a = BootUtils.getSubsystemFromClassName(subsystemClassName, configurationFileName, subsystemAlias);
        } else {
            throw new IllegalArgumentException("no description or subsystem class has been specified");
        }
        a.startAgent();
    }

    static void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("c", "configuration", true, "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        commandLineOptions.addOption("a", "alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");
        commandLineOptions.addOption("s", "subsystem", true, "the subsystem full class name");
        commandLineOptions.getOption("subsystem").setArgName("SUBSYSTEM_CLASS");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                SubsystemBoot.usageCLI(commandLineOptions);
            } else {
                descriptionName = line.getOptionValue("description");
                configurationFileName = line.getOptionValue("configuration");
                subsystemAlias = line.getOptionValue("alias");
                subsystemClassName = line.getOptionValue("subsystem");
            }
        }
        catch (Exception e) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
        System.exit(0);
    }

    static {
        subsystemAlias = null;
    }
}

