/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    protected final Promise<JoinRsp> join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.join_promise.reset();
    }

    @Override
    public void join(Address address, boolean useFlushIfPresent) {
        this.joinInternal(address, false, useFlushIfPresent);
    }

    @Override
    public void joinWithStateTransfer(Address local_addr, boolean useFlushIfPresent) {
        this.joinInternal(local_addr, true, useFlushIfPresent);
    }

    protected void joinInternal(Address mbr, boolean joinWithStateTransfer, boolean useFlushIfPresent) {
        long join_attempts = 0L;
        this.leaving = false;
        this.join_promise.reset();
        while (!this.leaving) {
            if (this.installViewIfValidJoinRsp(this.join_promise, false)) {
                return;
            }
            long start = System.currentTimeMillis();
            Responses responses = (Responses)this.gms.getDownProtocol().down(Event.FIND_INITIAL_MBRS_EVT);
            if (this.installViewIfValidJoinRsp(this.join_promise, false)) {
                return;
            }
            responses.waitFor(this.gms.join_timeout);
            responses.done();
            long diff = System.currentTimeMillis() - start;
            if (responses.isEmpty()) {
                this.log.trace("%s: no members discovered after %d ms: creating cluster as first member", this.gms.local_addr, diff);
                this.becomeSingletonMember(mbr);
                return;
            }
            this.log.trace("%s: discovery took %d ms, members: %s", this.gms.local_addr, diff, responses);
            List<Address> coords = ClientGmsImpl.getCoords(responses);
            if (coords == null) {
                if (!this.firstOfAllClients(mbr, responses)) continue;
                return;
            }
            if (coords.size() > 1) {
                this.log.debug("%s: found multiple coords: %s", this.gms.local_addr, coords);
            }
            ++join_attempts;
            for (Address coord : coords) {
                this.log.debug("%s: sending JOIN(%s) to %s", this.gms.local_addr, mbr, coord);
                this.sendJoinMessage(coord, mbr, joinWithStateTransfer, useFlushIfPresent);
                if (this.installViewIfValidJoinRsp(this.join_promise, true)) {
                    return;
                }
                this.log.warn("%s: JOIN(%s) sent to %s timed out (after %d ms), on try %d", this.gms.local_addr, mbr, coord, this.gms.join_timeout, join_attempts);
            }
            if (this.gms.max_join_attempts == 0L || join_attempts < this.gms.max_join_attempts) continue;
            this.log.warn("%s: too many JOIN attempts (%d): becoming singleton", this.gms.local_addr, join_attempts);
            this.becomeSingletonMember(mbr);
            return;
        }
    }

    @Override
    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installViewIfValidJoinRsp(Promise<JoinRsp> join_promise, boolean block_for_rsp) {
        boolean success = false;
        JoinRsp rsp = null;
        try {
            if (join_promise.hasResult()) {
                rsp = join_promise.getResult(1L, true);
            } else if (block_for_rsp) {
                rsp = join_promise.getResult(this.gms.join_timeout, true);
            }
            success = rsp != null && this.isJoinResponseValid(rsp) && this.installView(rsp.getView(), rsp.getDigest());
            boolean bl = success;
            return bl;
        }
        finally {
            if (success) {
                this.sendViewAck(rsp.getView().getCreator());
            }
        }
    }

    protected boolean firstOfAllClients(Address joiner, Responses rsps) {
        this.log.trace("%s: could not determine coordinator from rsps %s", this.gms.local_addr, rsps);
        TreeSet<Address> clients = new TreeSet<Address>();
        clients.add(joiner);
        for (PingData response : rsps) {
            clients.add(response.getAddress());
        }
        this.log.trace("%s: clients to choose new coord from are: %s", this.gms.local_addr, clients);
        Address new_coord = (Address)clients.first();
        if (new_coord.equals(joiner)) {
            this.log.trace("%s: I (%s) am the first of the clients, will become coordinator", this.gms.local_addr, joiner);
            this.becomeSingletonMember(joiner);
            return true;
        }
        this.log.trace("%s: I (%s) am not the first of the clients, waiting for another client to become coordinator", this.gms.local_addr, joiner);
        Util.sleep(500L);
        return false;
    }

    protected boolean isJoinResponseValid(JoinRsp rsp) {
        if (rsp.getFailReason() != null) {
            throw new SecurityException(rsp.getFailReason());
        }
        Digest tmp_digest = rsp.getDigest();
        if (tmp_digest == null || tmp_digest.capacity() == 0) {
            this.log.warn("%s: digest is empty: digest=%s", this.gms.local_addr, rsp.getDigest());
            return false;
        }
        if (!tmp_digest.contains(this.gms.local_addr)) {
            this.log.error("%s: digest in JOIN_RSP does not contain myself; join response: %s", this.gms.local_addr, rsp);
            return false;
        }
        if (rsp.getView() == null) {
            this.log.error("%s: JoinRsp has a null view, skipping it", this.gms.local_addr);
            return false;
        }
        return true;
    }

    private boolean installView(View new_view, Digest digest) {
        if (!new_view.containsMember(this.gms.local_addr)) {
            this.log.error("%s: I'm not member of %s, will not install view", this.gms.local_addr, new_view);
            return false;
        }
        this.gms.installView(new_view, digest);
        if (this.gms.impl == null || this.gms.impl instanceof ClientGmsImpl) {
            this.gms.becomeParticipant();
        }
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        return true;
    }

    protected static String print(List<PingData> rsps) {
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : rsps) {
            sb.append(rsp.getAddress() + " ");
        }
        return sb.toString();
    }

    protected static String print(Responses rsps) {
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : rsps) {
            sb.append(rsp.getAddress() + " ");
        }
        return sb.toString();
    }

    void sendJoinMessage(Address coord, Address mbr, boolean joinWithTransfer, boolean useFlushIfPresent) {
        Message msg = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        GMS.GmsHeader hdr = joinWithTransfer ? new GMS.GmsHeader(11, mbr, useFlushIfPresent) : new GMS.GmsHeader(1, mbr, useFlushIfPresent);
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    void sendViewAck(Address coord) {
        Message view_ack = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(10));
        this.gms.getDownProtocol().down(new Event(1, view_ack));
    }

    private static List<Address> getCoords(Iterable<PingData> mbrs) {
        if (mbrs == null) {
            return null;
        }
        ArrayList<Address> coords = null;
        for (PingData mbr : mbrs) {
            if (!mbr.isCoord()) continue;
            if (coords == null) {
                coords = new ArrayList<Address>();
            }
            if (coords.contains(mbr.getAddress())) continue;
            coords.add(mbr.getAddress());
        }
        return coords;
    }

    void becomeSingletonMember(Address mbr) {
        View new_view = View.create(mbr, 0L, mbr);
        Digest initial_digest = new Digest(mbr, 0L, 0L);
        this.gms.installView(new_view, initial_digest);
        this.gms.becomeCoordinator();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        this.log.debug("%s: created cluster (first member). My view is %s, impl is %s", this.gms.getLocalAddress(), this.gms.getViewId(), this.gms.getImpl().getClass().getName());
    }
}

