/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Entity
@Table(indexes={@Index(columnList="binWidth,startTime")}, uniqueConstraints={@UniqueConstraint(columnNames={"startTime", "binWidth"})})
@Cacheable
@Immutable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="org.lsst.ccs.localdb.statusdb.model.StatTimeInterval")
@NamedQueries(value={@NamedQuery(name="findStatTimeInterval", query="from StatTimeInterval ti where ti.binWidth=:binWidth and ti.startTime=:t1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
public class StatTimeInterval
implements Serializable {
    private static final long serialVersionUID = 7128231906408578843L;
    private long id;
    private long startTime;
    private long binWidth;

    public StatTimeInterval() {
    }

    public StatTimeInterval(long startTime, long binWidth) {
        this.startTime = startTime;
        this.binWidth = binWidth;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Transient
    public long getEndTime() {
        return this.startTime + this.binWidth;
    }

    public long getBinWidth() {
        return this.binWidth;
    }

    public void setBinWidth(long binWidth) {
        this.binWidth = binWidth;
    }
}

