/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;

@Entity
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="org.lsst.ccs.localdb.statusdb.model.AgentState")
@NamedQueries(value={@NamedQuery(name="findAgentState", query="from AgentState ast where ast.agentDesc.agentName=:subsystemName and ast.baseState.id=:baseStateId ", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Table(indexes={@Index(columnList="agentName"), @Index(columnList="baseStateId")})
public class AgentState
implements Serializable {
    private static final long serialVersionUID = -8367786148299296222L;
    private long id;
    private AgentDesc agentDesc;
    private BaseState baseState;
    private Map<String, InnerStateDesc> innerStates = new HashMap<String, InnerStateDesc>();

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @ManyToOne(optional=false)
    public BaseState getBaseState() {
        return this.baseState;
    }

    public void setBaseState(BaseState baseState) {
        this.baseState = baseState;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @MapKey(name="enumClassName")
    public Map<String, InnerStateDesc> getInnerStates() {
        return this.innerStates;
    }

    public void setInnerStates(Map<String, InnerStateDesc> innerStates) {
        this.innerStates = innerStates;
    }

    @Transient
    public Map<String, String> asFlatStatesMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("org.lsst.ccs.bus.states.AlertState", this.baseState.getAlertState());
        res.put("org.lsst.ccs.bus.states.PhaseState", this.baseState.getPhaseState());
        res.put("org.lsst.ccs.bus.states.CommandState", this.baseState.getCommandState());
        res.put("org.lsst.ccs.bus.states.OperationalState", this.baseState.getOperationalState());
        res.put("org.lsst.ccs.bus.states.ConfigState", this.baseState.getConfigState());
        for (InnerStateDesc isd : this.innerStates.values()) {
            res.put(isd.getEnumClassName(), isd.getEnumValue());
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.agentDesc.getAgentName());
        sb.append(":").append(this.baseState.toString()).append(",");
        for (InnerStateDesc isd : this.innerStates.values()) {
            sb.append(isd.toString()).append(",");
        }
        return sb.toString();
    }
}

