/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertData;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.model.StatusMessageData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class StatusPersister
extends BatchPersister
implements StatusMessageListener,
AgentPresenceListener {
    private final SessionFactory fac;
    private final List<String> agentsToCheck = new CopyOnWriteArrayList<String>();

    public StatusPersister(SessionFactory fac) {
        super(fac);
        StatusDataPersister.log.fine((Object)"Starting AlertPersister");
        this.fac = fac;
        Session sess = this.fac.openSession();
        sess.close();
    }

    public void onStatusMessage(StatusMessage msg) {
        if (this.agentsToCheck.size() > 0 && msg instanceof StatusRuntimeInfo && this.agentsToCheck.contains(msg.getOriginAgentInfo().getName())) {
            this.pushActiveAlerts(msg.getOriginAgentInfo().getName(), System.currentTimeMillis() - (long)(((StatusRuntimeInfo)msg).getRuntimeInfo().getUptime() * 1000));
        }
        if (msg instanceof StatusAlert) {
            StatusClearedAlert sca;
            String[] clearedAlerts;
            StatusAlert statusAlert = (StatusAlert)msg;
            RaisedAlertSummary alertSummary = statusAlert.getRaisedAlertSummary();
            if (statusAlert instanceof StatusRaisedAlert) {
                String alertId = ((Alert)statusAlert.getEncodedData()).getAlertId();
                String alertDescription = ((StatusRaisedAlert)statusAlert).getCause();
                AlertState currentSeverity = alertSummary.getRaisedAlert(alertId).getLatestAlertState();
                RaisedAlertData arad = new RaisedAlertData(currentSeverity, alertDescription, msg.getTimeStamp());
                this.addToQueue(new Object[]{arad, statusAlert, alertId});
            } else if (statusAlert instanceof StatusClearedAlert && (clearedAlerts = (sca = (StatusClearedAlert)statusAlert).getClearAlertIds()) != null) {
                for (String clearedId : clearedAlerts) {
                    ClearedAlertData cad = new ClearedAlertData();
                    cad.setTime(msg.getTimeStamp());
                    this.addToQueue(new Object[]{cad, statusAlert, clearedId});
                }
            }
        } else if (msg instanceof StatusStateChangeNotification) {
            StatusStateChangeNotification statusSCN = (StatusStateChangeNotification)msg;
            StateBundle oldState = statusSCN.getOldState();
            StateBundle newState = statusSCN.getNewState();
            StateChangeNotificationData scnd = new StateChangeNotificationData();
            scnd.setTime(msg.getTimeStamp());
            this.addToQueue(new Object[]{scnd, statusSCN, oldState, newState});
        }
    }

    public void connecting(AgentInfo agent) {
        if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.agentsToCheck.add(agent.getName());
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.pushActiveAlerts(agent.getName(), System.currentTimeMillis());
        }
    }

    private void pushActiveAlerts(String agentName, long agentStartTime) {
        this.agentsToCheck.remove(agentName);
        Session sess = this.fac.openSession();
        Transaction tx = sess.beginTransaction();
        StatusDataPersister.log.info((Object)("updating active alerts for agent : " + agentName));
        Query q = sess.createQuery("from RaisedAlertData rad where rad.agentDesc.agentName=:name and rad.active=true and rad.time<=:t");
        q.setString("name", agentName);
        q.setLong("t", agentStartTime);
        List res = q.list();
        for (RaisedAlertData rad : res) {
            rad.setActive(Boolean.valueOf(false));
            sess.update((Object)rad);
        }
        tx.commit();
        sess.close();
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        StatusMessageData msgData = (StatusMessageData)obj[0];
        StatusMessage statusMsg = (StatusMessage)obj[1];
        AgentInfo ai = statusMsg.getOriginAgentInfo();
        StateBundle state = statusMsg.getState();
        AgentDesc agDesc = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        msgData.setAgentDesc(agDesc);
        AgentState stateData = LocaldbFacade.getAgentState((AgentInfo)ai, (StateBundle)state, (Session)sess);
        msgData.setAgentState(stateData);
        if (msgData instanceof AlertData) {
            AlertData alData = (AlertData)msgData;
            StatusAlert statusAlert = (StatusAlert)statusMsg;
            String alertId = (String)obj[2];
            if (statusAlert instanceof StatusRaisedAlert) {
                Alert al = ((StatusRaisedAlert)statusAlert).getRaisedAlert();
                AlertDesc ad = LocaldbFacade.getAlertDescOrPersist((AgentDesc)agDesc, (Alert)al, (Session)sess);
                alData.setAlertDesc(ad);
                sess.persist((Object)alData);
            } else if (statusAlert instanceof StatusClearedAlert) {
                AlertDesc ad = LocaldbFacade.getAlertDesc((AgentDesc)agDesc, (String)alertId, (Session)sess);
                if (ad != null) {
                    alData.setAlertDesc(ad);
                    sess.persist((Object)alData);
                } else {
                    StatusDataPersister.log.warn((Object)("could not find description for alert with id " + alertId));
                }
                Query q = sess.createQuery("from RaisedAlertData rad where rad.agentDesc.agentName=:name and rad.alertDesc.alertId =:id and rad.active=true").setString("id", alertId).setString("name", agDesc.getAgentName());
                List res = q.list();
                for (RaisedAlertData arad : res) {
                    arad.setClearingAlert((ClearedAlertData)alData);
                    sess.update((Object)arad);
                }
                StatusDataPersister.log.fine((Object)("cleared " + res.size() + " instances of " + agDesc.getAgentName() + "/" + alertId));
            }
        } else if (msgData instanceof StateChangeNotificationData) {
            StateChangeNotificationData scnd = (StateChangeNotificationData)msgData;
            StateBundle oldState = (StateBundle)obj[2];
            scnd.setOldState(LocaldbFacade.getAgentState((AgentInfo)ai, (StateBundle)oldState, (Session)sess));
            sess.persist((Object)scnd);
        }
    }
}

