/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;

public abstract class BatchPersister
implements Runnable {
    private final Queue<Object[]> rq = new ConcurrentLinkedQueue<Object[]>();
    private final SessionFactory fac;

    public BatchPersister(SessionFactory fac) {
        this.fac = fac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Object[]> workingList = new ArrayList<Object[]>(1000);
        boolean empty = false;
        while (!empty) {
            Object[] d;
            for (int i = 0; i < 1000 && (d = this.rq.poll()) != null; ++i) {
                workingList.add(d);
            }
            if (workingList.isEmpty()) {
                empty = true;
                continue;
            }
            StatusDataPersister.log.debug((Object)(this.getClass().getSimpleName() + " start batch processing of " + workingList.size() + " entities."));
            Session sess = this.fac.openSession();
            Transaction tx = null;
            try {
                tx = sess.beginTransaction();
                for (Object[] o : workingList) {
                    try {
                        this.persist(o, sess);
                    }
                    catch (Exception e) {
                        throw new Exception("Failed to persist object (" + o[1] + ") " + o[0], e);
                    }
                }
                tx.commit();
            }
            catch (Exception ex) {
                StatusDataPersister.log.error((Object)("caught exception when persisting : " + ex), (Throwable)ex);
                try {
                    if (tx == null || tx.getStatus() != TransactionStatus.ACTIVE && tx.getStatus() != TransactionStatus.MARKED_ROLLBACK) continue;
                    tx.rollback();
                }
                catch (Exception rbEx) {
                    StatusDataPersister.log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                }
            }
            finally {
                if (sess.isOpen()) {
                    sess.close();
                }
                workingList.clear();
            }
        }
        StatusDataPersister.log.debug((Object)(this.getClass().getSimpleName() + " leaving batch processing loop"));
    }

    public void addToQueue(Object[] obj) {
        this.rq.add(obj);
    }

    public abstract void persist(Object[] var1, Session var2);
}

