package org.lsst.ccs.localdb.configdb;

import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.framework.Module;

import java.rmi.RemoteException;
import java.util.List;

/**
 * A CCS module that delegates Configuration Service calls to a local
 * <TT>ConfigurationServiceImpl</TT> object.
 * @author bamade
 */
// Date: 07/06/12

public class ConfigurationServerModule extends Module implements ConfigurationService {
    ConfigurationServiceImpl service =  ConfigurationServiceImpl.ON_DATABASE;
    ConfigurationFacade facade = service.getFacade() ;

    public ConfigurationServerModule() {
        super("main");
    }

    public ConfigurationServerModule(ConfigurationServiceImpl service) {
        super("main");
        this.service = service;
    }

    @Override
    public DescriptionResult registerSubsystemDescription(SubsystemDescription newDescription) throws RemoteException {
        return service.registerSubsystemDescription(newDescription);
    }

    @Override
    public DescriptionResult deprecateSubsystemDescription(String subsystemName, String tag) throws RemoteException {
        return service.deprecateSubsystemDescription(subsystemName, tag);
    }

    @Override
    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws RemoteException {
        return service.getActiveSubsystemDescription(name, tag) ;
    }

    @Override
    public ProfileResult registerConfigProfile(ConfigProfile newProfile) throws RemoteException {
        return service.registerConfigProfile(newProfile);
    }

    @Override
    public ProfileResult registerConfiguration(String subsystemName, String categoryName, String configurationName, String tag,
                                               String user, int level) throws RemoteException{
        return service.registerConfiguration(subsystemName,categoryName, configurationName,tag,user,level) ;
    }

    @Override
    public ProfileResult deprecateConfigProfile(String subsystemName, String descriptionName, String name, String tag) throws RemoteException {
        return service.deprecateConfigProfile(subsystemName, descriptionName, name, tag);
    }

    @Override
    public ConfigProfile getActiveConfigProfile(String subsystemName, String descriptionName, String name, String tag) throws RemoteException {
        return service.getActiveConfigProfile(subsystemName, descriptionName, name, tag) ;
    }

    @Override
    public ParameterConfiguration modifyParmConf(ParameterConfiguration engineeringModeParm) throws RemoteException {
        return service.modifyParmConf(engineeringModeParm) ;
    }

    @Override
    public ConfigProfile getConfigRunningAt(String subsystemName, String descriptionName, String category, long date) throws RemoteException {
        return service.getConfigRunningAt(subsystemName, descriptionName, category, date);
    }

    @Override
    public String getActiveValueAt(String subsystemName, String descriptionName, String category, String parameterPath, long date) throws RemoteException {
        return service.getActiveValueAt(subsystemName, descriptionName, category, parameterPath,date);
    }


    @Override
    public ConfigProfile getConfigValidAt(String subsystemName, String name, String tag, long date) throws RemoteException {
        return service.getConfigValidAt(subsystemName, name, tag, date);
    }


    @Override
    public String getValueValidAt(String subsystemName, String profileName, String profileTag, String parameterPath, long date) throws RemoteException {
        return service.getValueValidAt(subsystemName, profileName, profileTag, parameterPath, date);
    }

    @Override
    public ConfigProfile getPrevious(ConfigProfile current) throws RemoteException {
        return service.getPrevious(current);
    }

    @Override
    public ConfigProfile getNext(ConfigProfile current) throws RemoteException {
        return service.getNext(current);
    }

    @Override
    public SubsystemDescription getPrevious(SubsystemDescription current) throws RemoteException {
        return service.getPrevious(current);
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) throws RemoteException {
        return service.simpleHQLRequest(hqlString);
    }

    //TODO : register run events by listening to Status bus!


}
