/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.StatusPersister;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;

public class StatusPersisterSubsystem
extends Subsystem {
    private final StatusDataPersister dataStatusBatchPersister;
    private final StatusPersister statusPersister;
    private static SessionFactory fac;

    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersisterSubsystem(Properties p) {
        super("localdb", AgentInfo.AgentType.SERVICE);
        if (p == null) {
            p = new Properties();
        }
        StatusPersisterSubsystem.init(p);
        this.dataStatusBatchPersister = new StatusDataPersister(fac);
        this.statusPersister = new StatusPersister(fac);
    }

    public void doStart() {
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.statusPersister);
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.dataStatusBatchPersister, BusMessageFilterFactory.messageClass(StatusData.class).and(BusMessageFilterFactory.messageOrigin(null)));
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.statusPersister, BusMessageFilterFactory.messageOrigin(null).and(BusMessageFilterFactory.messageClass(StatusAlert.class).or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class))));
        this.getScheduler().scheduleWithFixedDelay((Runnable)this.dataStatusBatchPersister, 0L, 1L, TimeUnit.SECONDS);
        this.getScheduler().scheduleWithFixedDelay((Runnable)this.statusPersister, 0L, 1L, TimeUnit.SECONDS);
        this.getScheduler().scheduleAtFixedRate(() -> this.publishSubsystemDataOnStatusBus(new KeyValueData("statistics", (Serializable)new CacheStatistics(fac))), 1L, 5L, TimeUnit.MINUTES);
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        StatusPersisterSubsystem.parseArgs(args, p);
        StatusPersisterSubsystem system = new StatusPersisterSubsystem(p);
        system.start();
    }

    private static void parseArgs(String[] args, Properties p) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("u", "update", false, "Start the Trending Ingest Module in update mode.");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                StatusPersisterSubsystem.usage(commandLineOptions);
            } else if (line.hasOption("update")) {
                p.setProperty("hibernate.hbm2ddl.auto", "update");
            }
        }
        catch (Exception e) {
            StatusPersisterSubsystem.usage(commandLineOptions);
        }
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "TrendingIngestModule", "", options, "", true);
        System.exit(0);
    }
}

