/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.TrendingPublisherTest;

public class AlertPublisherSubsystem
extends Subsystem
implements HasLifecycle {
    private CyclicBarrier barrier;

    public AlertPublisherSubsystem(String name) {
        super(name, AgentInfo.AgentType.WORKER);
    }

    public void start() {
        this.getAlertService().addClearAlertHandler(alert -> ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
        this.updateAgentState(new Enum[]{State.IDLE});
    }

    @Command
    void fireAlertsRaising(Collection<TrendingPublisherTest.AlertProfile> alertProfiles) throws Exception {
        if (alertProfiles.isEmpty()) {
            return;
        }
        this.updateAgentState(new Enum[]{State.BUSY});
        int nAlerts = alertProfiles.size();
        this.barrier = new CyclicBarrier(nAlerts, () -> this.updateAgentState(new Enum[]{State.IDLE}));
        for (TrendingPublisherTest.AlertProfile ap : alertProfiles) {
            new Thread(new AlertPublisher(ap)).start();
        }
    }

    private class AlertPublisher
    implements Runnable {
        private final TrendingPublisherTest.AlertProfile ap;
        private final Alert alert;

        AlertPublisher(TrendingPublisherTest.AlertProfile ap) {
            this.ap = ap;
            this.alert = new Alert(this.ap.alertId, this.ap.alertDesc);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.ap.total; ++i) {
                AlertState state = AlertState.WARNING;
                if (i > this.ap.nWarns && i < this.ap.nWarns + this.ap.nAlarms) {
                    state = AlertState.ALARM;
                }
                AlertPublisherSubsystem.this.getAlertService().raiseAlert(this.alert, state, this.ap.alertCause);
                try {
                    Thread.sleep(this.ap.interval);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                AlertPublisherSubsystem.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static enum State {
        IDLE,
        BUSY;

    }
}

