/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.NaturalIdCacheStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;

public class CacheStatistics
implements Serializable {
    private static final long serialVersionUID = -6955983311743974515L;
    @SkipEncoding
    private static final String[] namedQueries = new String[]{"findAlertDesc", "findInnerStateDesc", "findDataDesc", "findAgentState", "findBaseState", "findStatData", "findStatDesc", "findDataGroup"};
    @SkipEncoding
    private static final Class[] cachedEntities = new Class[]{AlertDesc.class, InnerStateDesc.class, DataDesc.class, AgentState.class, BaseState.class, StatTimeInterval.class, StatData.class, StatDesc.class, StateBundleDesc.class, DataGroup.class};
    private final Map<String, QueryCacheStats> queries = new HashMap<String, QueryCacheStats>();
    private final Map<String, SLCacheStats> slc = new HashMap<String, SLCacheStats>();
    private final Map<String, EntityStats> entities = new HashMap<String, EntityStats>();
    private final Map<String, NaturalIdStats> naturalId = new HashMap<String, NaturalIdStats>();
    private final Map<String, Long> sessionStats = new HashMap<String, Long>();

    public CacheStatistics(SessionFactory fac) {
        Statistics stats = fac.getStatistics();
        Session sess = fac.openSession();
        for (String query : namedQueries) {
            this.queries.put(query, new QueryCacheStats(query, stats.getQueryStatistics(sess.getNamedQuery(query).getQueryString())));
        }
        for (Class cls : cachedEntities) {
            this.slc.put(cls.getSimpleName(), new SLCacheStats(cls.getSimpleName(), stats.getSecondLevelCacheStatistics(cls.getName())));
            this.entities.put(cls.getSimpleName(), new EntityStats(cls.getSimpleName(), stats.getEntityStatistics(cls.getName())));
        }
        Class<StandardQueryCache> regionName = StandardQueryCache.class;
        this.slc.put(regionName.getSimpleName(), new SLCacheStats(regionName.getSimpleName(), stats.getSecondLevelCacheStatistics(regionName.getName())));
        for (Class cls : new Class[]{StatTimeInterval.class}) {
            this.naturalId.put(cls.getSimpleName(), new NaturalIdStats(cls.getSimpleName(), stats.getNaturalIdCacheStatistics(cls.getName() + "##NaturalId")));
        }
        this.sessionStats.put("connectCount", stats.getConnectCount());
        this.sessionStats.put("flushCount", stats.getFlushCount());
        this.sessionStats.put("sessionOpenCount", stats.getSessionOpenCount());
        this.sessionStats.put("sessionCloseCount", stats.getSessionCloseCount());
        this.sessionStats.put("transactionCount", stats.getTransactionCount());
        this.sessionStats.put("successfulTransactionCount", stats.getSuccessfulTransactionCount());
        stats.clear();
        sess.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("********** Hibernate statistics **********\n");
        sb.append("\n ***** NaturalId Cache Statistics *****\n");
        TreeSet<String> sortedKeys = new TreeSet<String>(this.naturalId.keySet());
        for (String key : sortedKeys) {
            sb.append(this.naturalId.get(key).toString());
        }
        sb.append("\n ***** Query Statistics *****\n");
        sortedKeys = new TreeSet<String>(this.queries.keySet());
        for (String key : sortedKeys) {
            sb.append(this.queries.get(key).toString());
        }
        sb.append("\n\n ***** Second Level Cache Statistics *****\n");
        sortedKeys = new TreeSet<String>(this.slc.keySet());
        for (String key : sortedKeys) {
            sb.append(this.slc.get(key).toString());
        }
        sb.append("\n\n ***** Entity Statistics *****\n");
        sortedKeys = new TreeSet<String>(this.entities.keySet());
        for (String key : sortedKeys) {
            sb.append(this.entities.get(key).toString());
        }
        return sb.toString();
    }

    private static class NaturalIdStats
    implements Serializable {
        private static final long serialVersionUID = 2196590285891545914L;
        @SkipEncoding
        private String name = "";
        private final long hit;
        private final long miss;
        private final long put;
        private final long count;

        private NaturalIdStats(String name, NaturalIdCacheStatistics stats) {
            this.name = name;
            this.hit = stats.getHitCount();
            this.miss = stats.getMissCount();
            this.put = stats.getPutCount();
            this.count = stats.getElementCountInMemory();
        }

        public String toString() {
            return this.name + " :\n\t hits : " + this.hit + "\t misses : " + this.miss + "\t puts : " + this.put + "\t count : " + this.count + "\n";
        }
    }

    private static class EntityStats
    implements Serializable {
        private static final long serialVersionUID = 105526900767640499L;
        @SkipEncoding
        private String name = "";
        private final long load;
        private final long fetch;

        private EntityStats(String name, EntityStatistics stats) {
            this.name = name;
            this.load = stats.getLoadCount();
            this.fetch = stats.getFetchCount();
        }

        public String toString() {
            return this.name + " :\n\t load : " + this.load + "\t fetch : " + this.fetch + "\n";
        }
    }

    private static class SLCacheStats
    implements Serializable {
        private static final long serialVersionUID = -4475368776790422166L;
        @SkipEncoding
        private String region = "";
        private final long hit;
        private final long miss;
        private final long put;
        private final long count;

        private SLCacheStats(String region, SecondLevelCacheStatistics stats) {
            this.region = region;
            this.count = stats.getElementCountInMemory();
            this.hit = stats.getHitCount();
            this.miss = stats.getMissCount();
            this.put = stats.getPutCount();
        }

        public String toString() {
            return this.region + " :\n\t hits : " + this.hit + "\t misses : " + this.miss + "\t puts : " + this.put + "\t count : " + this.count + "\n";
        }
    }

    private static class QueryCacheStats
    implements Serializable {
        private static final long serialVersionUID = 5282982444660929176L;
        @SkipEncoding
        private String query = "";
        private final long hit;
        private final long miss;
        private final long put;
        private final long avgExec;

        private QueryCacheStats(String query, QueryStatistics stats) {
            this.query = query;
            this.hit = stats.getCacheHitCount();
            this.miss = stats.getCacheMissCount();
            this.put = stats.getCachePutCount();
            this.avgExec = stats.getExecutionAvgTime();
        }

        public String toString() {
            return this.query + " :\n\t hits : " + this.hit + "\t misses : " + this.miss + "\t puts : " + this.put + "\t average execution time : " + this.avgExec + "\n";
        }
    }
}

