/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.utilities.logging.Logger;

public class TrendingPublisherAgent
extends Agent {
    private CyclicBarrier barrier;
    double range = 20.0;
    Random rnd = new Random();
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.framework");

    public TrendingPublisherAgent(String agentName) {
        super(agentName, AgentInfo.AgentType.WORKER);
    }

    public void start() {
        this.updateAgentState(new Enum[]{State.IDLE});
    }

    @ConfigurationParameterChanger
    @Command
    public void setRange(double range) {
        System.out.println("range " + range);
        this.range = range;
    }

    @Command
    public double getRange() {
        return this.range;
    }

    public void fireTemperatureDataPublication(int nTimes, int nThreads, int intervalMillis) {
        this.updateAgentState(new Enum[]{State.BUSY});
        this.barrier = new CyclicBarrier(nThreads, () -> this.updateAgentState(new Enum[]{State.IDLE}));
        KeyValueData metaData = new KeyValueData("temp/unit", (Serializable)((Object)"K"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        metaData = new KeyValueData("temp2/tempData1/unit", (Serializable)((Object)"K"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        metaData = new KeyValueData("temp2/tempData2/unit", (Serializable)((Object)"F"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        metaData = new KeyValueData("temp2/tempData3/unit", (Serializable)((Object)"C"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        metaData = new KeyValueData("t1/unit", (Serializable)((Object)"K"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        metaData = new KeyValueData("t2/unit", (Serializable)((Object)"C"), System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValueMetaData);
        this.publishSubsystemDataOnStatusBus(metaData);
        int n = nTimes;
        for (int i = 0; i < nThreads; ++i) {
            int frac;
            if (i == nThreads - 1) {
                frac = n;
            } else {
                frac = n / nThreads;
                n -= frac;
            }
            new Thread(new TemperaturePublisher(frac, intervalMillis)).start();
        }
    }

    public static class TemperatureTrendingTest
    implements Serializable {
        private static final long serialVersionUID = 1905084226818984789L;
        public double tempData1;
        public double tempData2;
        public double tempData3;
    }

    class TemperaturePublisher
    implements Runnable {
        private final int nTimes;
        private final int intervalMillis;
        private final int periodMillis;

        TemperaturePublisher(int nTimes, int intervalMillis) {
            this.nTimes = nTimes;
            this.intervalMillis = intervalMillis;
            this.periodMillis = nTimes * intervalMillis / 3;
        }

        double getTemperature() {
            double dt = System.currentTimeMillis() % (long)this.periodMillis;
            return TrendingPublisherAgent.this.range * Math.sin(Math.PI * 2 / (double)this.periodMillis * dt) + TrendingPublisherAgent.this.rnd.nextDouble() * 2.0 - 1.0;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.nTimes; ++i) {
                try {
                    Thread.sleep(this.intervalMillis);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                double t = this.getTemperature();
                log.fine((Object)("publishing temperature " + t));
                KeyValueData d = new KeyValueData("temp", (Serializable)Double.valueOf(t));
                TrendingPublisherAgent.this.publishSubsystemDataOnStatusBus(d);
                TemperatureTrendingTest tt = new TemperatureTrendingTest();
                tt.tempData1 = t;
                tt.tempData2 = t * 9.0 / 5.0 + 32.0;
                tt.tempData3 = t + 273.15;
                KeyValueData d2 = new KeyValueData("temp2", (Serializable)tt);
                TrendingPublisherAgent.this.publishSubsystemDataOnStatusBus(d2);
                KeyValueDataList list = new KeyValueDataList();
                list.addData("t1", (Serializable)Double.valueOf(t));
                list.addData("t2", (Serializable)Double.valueOf(t + 273.15));
                TrendingPublisherAgent.this.publishSubsystemDataOnStatusBus((KeyValueData)list);
            }
            try {
                TrendingPublisherAgent.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static enum State {
        IDLE,
        BUSY;

    }
}

