/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.io.Serializable;
import java.time.Duration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

public class ConfigurationPersisterTest
extends LocaldbTestTemplate {
    private static HibernateDAO dbInterface;
    private static Agent persister;
    private static Subsystem s;
    private static Agent a;
    private static ConcurrentMessagingUtils cmu;
    private static ConfigurationService sce;
    private static final Predicate<BusMessage<? extends Serializable, ?>> filter;

    @BeforeClass
    public static void setupFacade() throws Exception {
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testconfigdb");
        p.setProperty("hibernate.use_sql_comments", "false");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.format_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.startAgent();
        cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        s = BootUtils.getSubsystemFromFile((String)"configAgent");
        sce = s.getConfigurationService();
        persister = BootUtils.getSubsystemFromFile((String)"localdb");
        dbInterface = new HibernateDAO(sessionFactory);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        persister.shutdownAgent();
        s.shutdownAgent();
        a.shutdownAgent();
    }

    @Test
    public void testConfigurationPersister() throws Exception {
        Future future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        Future futureBis = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        persister.startAgent();
        persister.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        s.startAgent();
        StatusConfigurationInfo sciSafe = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciSafe = (ConfigurationInfo)sciSafe.getObject();
        Assert.assertEquals((Object)"configAgent[safe,A:safe,B:safe,C:safe,timers:safe]", (Object)ciSafe.getConfigurationName());
        StatusConfigurationInfo sciSafeBis = (StatusConfigurationInfo)futureBis.get();
        ConfigurationInfo ciSafeBis = (ConfigurationInfo)sciSafeBis.getObject();
        Assert.assertEquals((Object)"configAgent[safe,A:safe,B:safe,C:safe,timers:safe]", (Object)ciSafeBis.getConfigurationName());
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.loadConfiguration(new String[0]);
        StatusConfigurationInfo sciDefault = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciDefault = sciDefault.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.change("comp1", "intC", (Object)10);
        StatusConfigurationInfo sciDirtyC = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciDirtyC = sciDirtyC.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.saveAllChanges("GLOBAL_D");
        StatusConfigurationInfo sciSaveGlobalDefault = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciSaveGlobalDefault = sciSaveGlobalDefault.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.change("comp1", "intB", (Object)1);
        StatusConfigurationInfo sciDirty = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciDirty = sciDirty.getConfigurationInfo();
        Assert.assertTrue((String)"ConfigurationInfo object should be dirty for cat B", (boolean)ciDirty.hasChangesForCategory("B"));
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.saveChangesForCategoriesAs(new String[]{"B:confB1"});
        StatusConfigurationInfo sciSaveAsConfB1 = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciSaveAsConfB1 = sciSaveAsConfB1.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.saveAllChanges("GLOBAL_B1");
        StatusConfigurationInfo sciSaveGlobalAsConfB1 = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciSaveGlobal = sciSaveAsConfB1.getConfigurationInfo();
        sce.submitChange("comp2", "intA", (Object)2);
        sce.submitChange("comp2", "intB", (Object)2);
        sce.submitChange("comp2", "intC", (Object)2);
        sce.submitChange("comp2", "intD", (Object)2);
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.commitBulkChange();
        StatusConfigurationInfo sciBulkChange = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciBulkChange = sciBulkChange.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.dropAllChanges();
        StatusConfigurationInfo sciDropAll = (StatusConfigurationInfo)future.get();
        ConfigurationInfo ciDropAll = sciDropAll.getConfigurationInfo();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.loadConfiguration(new String[0]);
        StatusConfigurationInfo sciLoadDefault = (StatusConfigurationInfo)future.get();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.loadCategories(new String[]{"B:confB1"});
        StatusConfigurationInfo sciLoadConfB1 = (StatusConfigurationInfo)future.get();
        future = cmu.startListeningForStatusBusMessage(filter, Duration.ofSeconds(10L));
        sce.loadGlobalConfiguration("GLOBAL_D", -1);
        StatusConfigurationInfo sciLoadGlobalD = (StatusConfigurationInfo)future.get();
        Thread.sleep(10000L);
        dbInterface.begin();
        Description desc = dbInterface.findDescriptionOrNull("config-agent", ciSafe.getAllParameterInfo());
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)desc);
        Assert.assertNotEquals((long)0L, (long)desc.getId());
        dbInterface.end();
        Set cats = ciSafe.getCategorySet();
        dbInterface.begin();
        Configuration runningConfig = null;
        ConfigurationInfoData cidSafe = dbInterface.getConfigurationInfoData(desc, sciSafe.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:safe(0),A:safe(0),B:safe(0),C:safe(0),timers:safe(0)]", (Object)cidSafe.getConfigurationDescriptionString());
        ConfigurationInfoData cidDefault = dbInterface.getConfigurationInfoData(desc, sciDefault.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:(0),C:(0),timers:(0)]", (Object)cidDefault.getConfigurationDescriptionString());
        ConfigurationInfoData cidDirtyC = dbInterface.getConfigurationInfoData(desc, sciDirtyC.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:(0),C:(0)*,timers:(0)]", (Object)cidDirtyC.getConfigurationDescriptionString());
        ConfigurationInfoData cidSaveGlobalDefault = dbInterface.getConfigurationInfoData(desc, sciSaveGlobalDefault.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[GLOBAL_D(0)][:(0),A:(0),B:(0),C:(1),timers:(0)]", (Object)cidSaveGlobalDefault.getConfigurationDescriptionString());
        ConfigurationInfoData cidSaveAsConfB1 = dbInterface.getConfigurationInfoData(desc, sciSaveAsConfB1.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:confB1(0),C:(1),timers:(0)]", (Object)cidSaveAsConfB1.getConfigurationDescriptionString());
        ConfigurationInfoData cidSaveGlobalB1 = dbInterface.getConfigurationInfoData(desc, sciSaveGlobalAsConfB1.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[GLOBAL_B1(0)][:(0),A:(0),B:confB1(0),C:(1),timers:(0)]", (Object)cidSaveGlobalB1.getConfigurationDescriptionString());
        ConfigurationInfoData cidBulkChange = dbInterface.getConfigurationInfoData(desc, sciBulkChange.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0)*,A:(0)*,B:confB1(0)*,C:(1)*,timers:(0)]", (Object)cidBulkChange.getConfigurationDescriptionString());
        ConfigurationInfoData cidDropAll = dbInterface.getConfigurationInfoData(desc, sciDropAll.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:confB1(0),C:(1),timers:(0)]", (Object)cidDropAll.getConfigurationDescriptionString());
        ConfigurationInfoData cidLoadDefault = dbInterface.getConfigurationInfoData(desc, sciLoadDefault.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:(0),C:(1),timers:(0)]", (Object)cidLoadDefault.getConfigurationDescriptionString());
        ConfigurationInfoData cidLoadConfB1 = dbInterface.getConfigurationInfoData(desc, sciLoadConfB1.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[:(0),A:(0),B:confB1(0),C:(1),timers:(0)]", (Object)cidLoadConfB1.getConfigurationDescriptionString());
        ConfigurationInfoData cidLoadGlobalD = dbInterface.getConfigurationInfoData(desc, sciLoadGlobalD.getTimeStamp());
        Assert.assertEquals((Object)"config-agent[GLOBAL_D(0)][:(0),A:(0),B:(0),C:(1),timers:(0)]", (Object)cidLoadGlobalD.getConfigurationDescriptionString());
        for (String cat : cats) {
            runningConfig = dbInterface.getConfigRunningAt(desc, cat, sciSafe.getTimeStamp());
            Assert.assertNotNull((String)("for config \"" + runningConfig.getConfigurationDescriptionString() + "\" at time " + sciSafe.getTimeStamp()), (Object)runningConfig);
            Configuration cDefault = dbInterface.getConfigRunningAt(desc, cat, sciDefault.getTimeStamp());
            Assert.assertNotNull((String)("for cat \"" + cat + "\" at time " + sciDefault.getTimeStamp()), (Object)cDefault);
            Configuration cDirtyC = dbInterface.getConfigRunningAt(desc, cat, sciDirtyC.getTimeStamp());
            Assert.assertEquals((long)cDefault.getId(), (long)cDirtyC.getId());
            Configuration cSaveDefault = dbInterface.getConfigRunningAt(desc, cat, sciSaveGlobalDefault.getTimeStamp());
            ConfigurationRun cr = dbInterface.getConfigurationRunAt(desc, cat, sciSaveGlobalDefault.getTimeStamp());
            Assert.assertEquals((Object)"GLOBAL_D", (Object)cr.getGlobalConfiguration().getName());
            if (cat.equals("C")) {
                Assert.assertNotEquals((long)cDefault.getId(), (long)cSaveDefault.getId());
            } else {
                Assert.assertEquals((String)"version should not have incremented", (long)cDefault.getId(), (long)cSaveDefault.getId());
            }
            Configuration cSaveAsConfB1 = dbInterface.getConfigRunningAt(desc, cat, sciSaveAsConfB1.getTimeStamp());
            if (!cat.equals("B")) {
                Assert.assertEquals((String)"configuration should be unchanged", (long)cSaveDefault.getId(), (long)cSaveAsConfB1.getId());
            }
            ConfigurationRun crSaveGlobalB1 = dbInterface.getConfigurationRunAt(desc, cat, sciSaveGlobalAsConfB1.getTimeStamp());
            Assert.assertEquals((Object)"GLOBAL_B1", (Object)crSaveGlobalB1.getGlobalConfiguration().getName());
            Configuration cBulkChange = dbInterface.getConfigRunningAt(desc, cat, sciBulkChange.getTimeStamp());
            if (!cat.equals("B")) {
                Assert.assertEquals((String)"configuration should be unchanged", (long)cSaveAsConfB1.getId(), (long)cBulkChange.getId());
            }
            Configuration cDropAll = dbInterface.getConfigRunningAt(desc, cat, sciDropAll.getTimeStamp());
            if (!cat.equals("B")) {
                Assert.assertEquals((String)"configuration should be unchanged", (long)cBulkChange.getId(), (long)cDropAll.getId());
            }
            Configuration cLoadDefault = dbInterface.getConfigRunningAt(desc, cat, sciLoadDefault.getTimeStamp());
            Assert.assertEquals((String)("at " + sciLoadDefault.getTimeStamp() + " : "), (Object)"", (Object)cLoadDefault.getConfigName());
            Assert.assertTrue((boolean)cLoadDefault.isLatestVersion());
            Configuration cLoadConfB1 = dbInterface.getConfigRunningAt(desc, cat, sciLoadConfB1.getTimeStamp());
            Assert.assertTrue((boolean)cLoadConfB1.isLatestVersion());
            ConfigurationRun crLoadD = dbInterface.getConfigurationRunAt(desc, cat, sciLoadGlobalD.getTimeStamp());
            Assert.assertEquals((Object)"GLOBAL_D", (Object)crLoadD.getGlobalConfiguration().getName());
        }
        dbInterface.end();
    }

    static {
        filter = BusMessageFilterFactory.embeddedObjectClass(ConfigurationInfo.class).and(BusMessageFilterFactory.messageOrigin((String)"config-agent"));
    }
}

