/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.configdb.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.AgentPresenceEvent;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class ConfigurationPersister
implements ConfigurationDAO,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private ConfigurationFacade facade;
    private final Map<String, Description> aliveDescriptions = new HashMap<String, Description>();
    private final Map<String, CountDownLatch> descriptionReady = new HashMap<String, CountDownLatch>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final BlockingQueue<Object[]> ciQueue = new ArrayBlockingQueue<Object[]>(1000);
    private final Thread statusConfigurationInfoSerializer = new Thread(new ConfigurationInfoPersister());

    public void init() {
        this.s.setAgentProperty("org.lsst.ccs.config.service", "true");
    }

    public void start() {
        this.facade = new ConfigurationFacade(new HibernateDAO(StatusdbUtils.getSessionFactory(null)));
        this.statusConfigurationInfoSerializer.start();
    }

    public void stop() {
        this.statusConfigurationInfoSerializer.interrupt();
    }

    @Command
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDescription) throws ConfigurationServiceException {
        try {
            return this.facade.loadConfiguration(this.descriptionWaitAndGet(agentName), configDescription);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        try {
            return this.facade.loadGlobalConfiguration(this.descriptionWaitAndGet(agentName), name, version);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        try {
            return this.facade.findAvailableConfigurationsForCategory(this.descriptionWaitAndGet(agentName), category);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    @Command
    public boolean isAvailable() {
        return true;
    }

    @Command
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            return this.facade.registerStandaloneConfiguration(this.descriptionWaitAndGet(agentName), configInfo);
        }
        catch (Exception ex) {
            throw new ConfigurationServiceException("error at persistence layer", (Throwable)ex);
        }
    }

    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return null;
    }

    private Description descriptionWaitAndGet(String agentName) {
        try {
            this.descriptionReady.get(agentName).await();
            return this.aliveDescriptions.get(agentName);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot get description for " + agentName, ex);
        }
    }

    private void processFirstStatusConfigurationInfo(StatusConfigurationInfo sci, ConfigurationInfoData cid) throws Exception {
        ConfigurationInfo ci = sci.getConfigurationInfo();
        String agentName = cid.getAgentDesc().getAgentName();
        Description desc = this.facade.registerDescription(cid.getAgentDesc(), ci.getAllParameterInfo());
        log.finest((Object)("registered description for " + agentName + " with id " + desc.getId()));
        this.facade.cleanupConfigurationRuns(desc, cid.getTime());
        this.facade.registerConfiguration(desc, ci, cid);
        log.finest((Object)("registered initial configuration info : " + ci.getConfigurationName() + " at " + sci.getTimeStamp()));
        this.aliveDescriptions.put(agentName, desc);
    }

    public void submit(Object[] objs) {
        this.ciQueue.offer(objs);
    }

    private class ConfigurationInfoPersister
    implements Runnable {
        private ConfigurationInfoPersister() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object[] o;
                        Object key;
                        if ((key = (o = (Object[])ConfigurationPersister.this.ciQueue.take())[0]) instanceof ConfigurationInfoData) {
                            ConfigurationInfoData cid = (ConfigurationInfoData)key;
                            String name = cid.getAgentDesc().getAgentName();
                            StatusConfigurationInfo sci = (StatusConfigurationInfo)o[1];
                            Description desc = (Description)ConfigurationPersister.this.aliveDescriptions.get(name);
                            if (desc == null) {
                                ConfigurationPersister.this.processFirstStatusConfigurationInfo(sci, cid);
                                continue;
                            }
                            if (ConfigurationPersister.this.descriptionReady.get(name) != null) {
                                ((CountDownLatch)ConfigurationPersister.this.descriptionReady.get(name)).countDown();
                                ConfigurationPersister.this.facade.registerStandaloneStatusConfigurationInfo((Description)ConfigurationPersister.this.aliveDescriptions.get(name), cid);
                                continue;
                            }
                            log.fine((Object)("received configuration state at : " + sci.getTimeStamp() + " : " + sci.getConfigurationInfo().getConfigurationName()));
                            ConfigurationPersister.this.facade.registerConfiguration((Description)ConfigurationPersister.this.aliveDescriptions.get(name), sci.getConfigurationInfo(), cid);
                            continue;
                        }
                        if (key instanceof AgentPresenceEvent) {
                            AgentPresenceEvent ape = (AgentPresenceEvent)key;
                            AgentInfo agent = ape.getAgent();
                            if (ape.isConnecting()) {
                                String remote = agent.getAgentProperty("org.lsst.ccs.config.remote");
                                if (!"true".equals(remote)) continue;
                                log.finest((Object)("got connection event from " + agent.getName()));
                                ConfigurationPersister.this.descriptionReady.put(agent.getName(), new CountDownLatch(1));
                                continue;
                            }
                            log.finest((Object)("got disconnection event from " + agent.getName()));
                            Description desc = (Description)ConfigurationPersister.this.aliveDescriptions.remove(agent.getName());
                            if (desc == null) continue;
                            ConfigurationPersister.this.facade.stopConfigurationRuns(desc, ape.getTime());
                            continue;
                        }
                        log.info((Object)("configuration persister received unexpected object " + key.getClass()));
                    }
                }
                catch (InterruptedException ex) {
                    log.info((Object)"configuration info serializer thread interrupted", (Throwable)ex);
                    return;
                }
                catch (Exception ex) {
                    ConfigurationPersister.this.alertService.raiseAlert(LocalDBAlert.ConfigurationPersistenceException.getAlert(null, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
                    continue;
                }
                break;
            }
        }
    }
}

