/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.utilities.logging.Logger;

public class ConfigurationFacade {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private final HibernateDAO dbInterface;

    public ConfigurationFacade(HibernateDAO dbInterface) {
        this.dbInterface = dbInterface;
    }

    public Description registerDescription(AgentDesc ad, List<ConfigurationParameterInfo> cpis) throws Exception {
        this.dbInterface.begin();
        Description res = this.dbInterface.findDescriptionOrCreate(ad, cpis);
        this.dbInterface.end();
        return res;
    }

    public void stopConfigurationRuns(Description desc, long time) throws Exception {
        this.dbInterface.begin();
        Map activeRuns = this.dbInterface.getActiveConfigurationRuns(desc);
        for (ConfigurationRun cr : activeRuns.values()) {
            cr.setTstop(time);
        }
        this.dbInterface.end();
    }

    public ConfigurationDescription registerStandaloneConfiguration(Description desc, ConfigurationInfo ci) throws Exception {
        this.dbInterface.begin();
        Map<String, ConfigurationRun> newRuns = this.registerRuns(desc, ci, ci.getTimestamp());
        ConfigurationDescription cd = new ConfigurationDescription(ci.getCategorySet());
        for (ConfigurationRun cr : newRuns.values()) {
            cd.putTagForCategory(cr.getConfiguration().getCategory(), cr.getConfiguration().getConfigName(), Integer.valueOf(cr.getConfiguration().getVersion()));
        }
        this.dbInterface.end();
        return cd;
    }

    public void registerStandaloneStatusConfigurationInfo(Description desc, ConfigurationInfoData cid) throws Exception {
        this.dbInterface.begin();
        Map currentRuns = this.dbInterface.getActiveConfigurationRuns(desc);
        cid.setConfigurationRuns(currentRuns);
        this.dbInterface.persist((Object)cid);
        this.dbInterface.end();
    }

    public void registerConfiguration(Description desc, ConfigurationInfo ci, ConfigurationInfoData cid) throws Exception {
        long time = cid.getTime();
        cid.setDescription(desc);
        this.dbInterface.begin();
        Map<String, ConfigurationRun> newRuns = this.registerRuns(desc, ci, time);
        cid.setConfigurationRuns(newRuns);
        this.dbInterface.persist((Object)cid);
        log.fine((Object)("persisted configuration state at : " + cid.getTime() + " : " + cid.getConfigurationDescriptionString()));
        this.dbInterface.end();
    }

    private Map<String, ConfigurationRun> registerRuns(Description desc, ConfigurationInfo ci, long time) {
        Map currentRuns = this.dbInterface.getActiveConfigurationRuns(desc);
        HashMap<String, ConfigurationRun> newRuns = new HashMap<String, ConfigurationRun>();
        Map cpiMap = ConfigurationInfo.getParameterInfoGroupByCategory((List)ci.getAllParameterInfo());
        HashMap<String, Configuration> newConfigs = new HashMap<String, Configuration>();
        for (String cat : ci.getCategorySet()) {
            String nextTag = ci.getConfigNameForCategory(cat);
            Integer version = ci.getConfigVersion(cat);
            newConfigs.put(cat, this.dbInterface.getConfigurationOrCreate(desc, nextTag, cat, version.intValue(), (List)cpiMap.get(cat), time, (ConfigurationRun)currentRuns.get(cat)));
        }
        GlobalConfiguration gc = null;
        if (ci.getGlobalName() != null && !ci.hasChanges()) {
            gc = this.dbInterface.findGlobalConfigurationOrCreate(desc, ci.getGlobalName(), newConfigs);
        }
        for (String cat : ci.getCategorySet()) {
            Configuration baseConfig = (Configuration)newConfigs.get(cat);
            ConfigurationRun newRun = new ConfigurationRun(baseConfig, time);
            newRun.setGlobalConfiguration(gc);
            ConfigurationRun currentRun = (ConfigurationRun)currentRuns.get(cat);
            List changesForCat = ((List)cpiMap.get(cat)).stream().filter(cpi -> !cpi.isFinal() && cpi.isDirty()).collect(Collectors.toList());
            if (currentRun == null) {
                newRun = this.dbInterface.populateRunFromScratch(newRun, changesForCat);
            } else if (time <= currentRun.getTstart()) {
                if (time < currentRun.getTstart()) {
                    log.info((Object)("for " + desc.getAgentDesc().getAgentName() + ": received configuration info time (" + new Date(time) + ") is previous to an already persisted configuration state at " + new Date(currentRun.getTstart())));
                }
                newRun = currentRun;
            } else {
                newRun = this.dbInterface.populateRunFromPreviousRun(currentRun, newRun, changesForCat);
            }
            newRuns.put(cat, newRun);
        }
        return newRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationView loadConfiguration(Description desc, ConfigurationDescription configDesc) throws Exception {
        ConfigurationView view = new ConfigurationView(configDesc);
        this.dbInterface.begin();
        try {
            for (Map.Entry tags : configDesc.getCategoryTags().entrySet()) {
                Configuration request = this.dbInterface.getConfigurationOrNull(desc, (String)tags.getValue(), (String)tags.getKey(), ((Integer)configDesc.getCategoryVersions().get(tags.getKey())).intValue());
                if (request == null) {
                    throw new RuntimeException("cannot find configuration \"" + (String)tags.getKey() + "\":\"" + (String)tags.getValue() + "\"(" + configDesc.getCategoryVersions().get(tags.getKey()) + ")");
                }
                for (ConfigurationParameterValue cpv : request.getConfigurationParameterValues().values()) {
                    view.putParameterValue(cpv.getPath().getComponentName(), cpv.getPath().getParameterName(), cpv.getValue());
                }
            }
        }
        finally {
            this.dbInterface.end();
        }
        return view;
    }

    public ConfigurationView loadGlobalConfiguration(Description desc, String name, int version) throws Exception {
        this.dbInterface.begin();
        GlobalConfiguration gc = this.dbInterface.findGlobalConfiguration(desc, name, version);
        ConfigurationView res = null;
        if (gc != null) {
            ConfigurationDescription cd = new ConfigurationDescription(gc.getConfigurations().keySet());
            cd.setName(gc.getName(), gc.getVersion());
            res = new ConfigurationView(cd);
            for (Configuration c : gc.getConfigurations().values()) {
                cd.putTagForCategory(c.getCategory(), c.getCategory(), Integer.valueOf(c.getVersion()));
                for (ConfigurationParameterValue cpv : c.getConfigurationParameterValues().values()) {
                    res.putParameterValue(cpv.getPath().getComponentName(), cpv.getPath().getParameterName(), cpv.getValue());
                }
            }
        }
        this.dbInterface.end();
        return res;
    }

    public Set<String> findAvailableConfigurationsForCategory(Description desc, String category) throws Exception {
        HashSet<String> res = new HashSet<String>();
        this.dbInterface.begin();
        res.addAll(this.dbInterface.findAvailableConfigurationsForCategory(desc, category));
        this.dbInterface.end();
        return res;
    }

    void cleanupConfigurationRuns(Description desc, long time) throws Exception {
        this.dbInterface.begin();
        this.dbInterface.cleanupConfigurationRuns(desc, time);
        this.dbInterface.end();
    }
}

