/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.StatusPersister;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AlertData;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AlertPersister
extends BatchPersister
implements StatusMessageListener,
AgentPresenceListener {
    private final SessionFactory fac;
    private final List<String> agentsToCheck = new CopyOnWriteArrayList<String>();

    public AlertPersister(SessionFactory fac) {
        super(fac);
        StatusPersister.log.fine((Object)"Starting AlertPersister");
        this.fac = fac;
        Session sess = this.fac.openSession();
        sess.close();
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusClearedAlert sca;
        String[] clearedAlerts;
        if (this.agentsToCheck.size() > 0 && msg instanceof StatusRuntimeInfo && this.agentsToCheck.contains(msg.getOriginAgentInfo().getName())) {
            this.pushActiveAlerts(msg.getOriginAgentInfo().getName(), System.currentTimeMillis() - (long)(((StatusRuntimeInfo)msg).getRuntimeInfo().getUptime() * 1000));
        }
        StatusAlert statusAlert = (StatusAlert)msg;
        RaisedAlertSummary alertSummary = statusAlert.getRaisedAlertSummary();
        if (statusAlert instanceof StatusRaisedAlert) {
            String alertId = ((Alert)statusAlert.getEncodedData()).getAlertId();
            String alertDescription = ((StatusRaisedAlert)statusAlert).getCause();
            AlertState currentSeverity = alertSummary.getRaisedAlert(alertId).getLatestAlertState();
            RaisedAlertData arad = new RaisedAlertData(currentSeverity, alertDescription, msg.getTimeStamp());
            this.addToQueue(new Object[]{arad, statusAlert, alertId});
        } else if (statusAlert instanceof StatusClearedAlert && (clearedAlerts = (sca = (StatusClearedAlert)statusAlert).getClearAlertIds()) != null) {
            for (String clearedId : clearedAlerts) {
                ClearedAlertData cad = new ClearedAlertData();
                cad.setTime(msg.getTimeStamp());
                this.addToQueue(new Object[]{cad, statusAlert, clearedId});
            }
        }
    }

    public void connecting(AgentInfo agent) {
        if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.agentsToCheck.add(agent.getName());
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.pushActiveAlerts(agent.getName(), System.currentTimeMillis());
        }
    }

    private void pushActiveAlerts(String agentName, long agentStartTime) {
        this.agentsToCheck.remove(agentName);
        Session sess = this.fac.openSession();
        Transaction tx = sess.beginTransaction();
        StatusPersister.log.info((Object)("updating active alerts for agent : " + agentName));
        Query q = sess.createQuery("from RaisedAlertData rad where rad.agentDesc.agentName=:name and rad.active=true and rad.time<=:t");
        q.setString("name", agentName);
        q.setLong("t", agentStartTime);
        List res = q.list();
        for (RaisedAlertData rad : res) {
            rad.setActive(Boolean.valueOf(false));
            sess.update((Object)rad);
        }
        tx.commit();
        sess.close();
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        AlertData alData = (AlertData)obj[0];
        StatusAlert statusAlert = (StatusAlert)obj[1];
        String alertId = (String)obj[2];
        AgentInfo ai = statusAlert.getOriginAgentInfo();
        StateBundle state = statusAlert.getState();
        AgentDesc agDesc = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        alData.setAgentDesc(agDesc);
        alData.setAgentState(LocaldbFacade.getAgentState((AgentInfo)ai, (StateBundle)state, (Session)sess));
        if (statusAlert instanceof StatusRaisedAlert) {
            Alert al = ((StatusRaisedAlert)statusAlert).getRaisedAlert();
            AlertDesc ad = LocaldbFacade.getAlertDescOrPersist((AgentDesc)agDesc, (Alert)al, (Session)sess);
            alData.setAlertDesc(ad);
            sess.persist((Object)alData);
        } else if (statusAlert instanceof StatusClearedAlert) {
            AlertDesc ad = LocaldbFacade.getAlertDesc((AgentDesc)agDesc, (String)alertId, (Session)sess);
            if (ad != null) {
                alData.setAlertDesc(ad);
                sess.persist((Object)alData);
            } else {
                StatusPersister.log.warn((Object)("could not find description for alert with id " + alertId));
            }
            Query q = sess.createQuery("from RaisedAlertData rad where rad.agentDesc.agentName=:name and rad.alertDesc.alertId =:id and rad.active=true").setString("id", alertId).setString("name", agDesc.getAgentName());
            List res = q.list();
            for (RaisedAlertData arad : res) {
                arad.setClearingAlert((ClearedAlertData)alData);
                sess.update((Object)arad);
            }
            StatusPersister.log.fine((Object)("cleared " + res.size() + " instances of " + agDesc.getAgentName() + "/" + alertId));
        }
    }
}

