/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.test;

import java.io.Serializable;
import java.util.Random;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.logging.Logger;

public class TrendingTestPublisher
extends Module {
    double range = 20.0;
    Random rnd = new Random();
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.framework");

    public TrendingTestPublisher() {
        super("trendingTestPublisher", 1000);
    }

    @ConfigChanger
    @Command
    public void setRange(double range) {
        System.out.println("range " + range);
        this.range = range;
    }

    @Command
    public double getRange() {
        return this.range;
    }

    public double getTemperature() {
        double dt = (double)(System.currentTimeMillis() % 10000L) / 1000.0;
        return -100.0 + this.range * Math.sin(dt) + this.rnd.nextDouble() * 3.0;
    }

    public void tick() {
        this.setChanged();
        double t = this.getTemperature();
        log.fine((Object)("publishing temperature " + t));
        KeyValueData d = new KeyValueData("temp", (Serializable)Double.valueOf(t));
        this.getSubsystem().publishSubsystemDataOnStatusBus(d);
        TemperatureTrendingTest tt = new TemperatureTrendingTest();
        tt.tempData1 = t;
        tt.tempData2 = t * 9.0 / 5.0 + 32.0;
        tt.tempData3 = t + 273.15;
        KeyValueData d2 = new KeyValueData("temp2", (Serializable)tt);
        this.getSubsystem().publishSubsystemDataOnStatusBus(d2);
        KeyValueDataList list = new KeyValueDataList();
        list.addData("t1", (Serializable)Double.valueOf(t));
        list.addData("t2", (Serializable)Double.valueOf(t + 273.15));
        this.getSubsystem().publishSubsystemDataOnStatusBus((KeyValueData)list);
    }

    public static class TemperatureTrendingTest
    implements Serializable {
        public double tempData1;
        public double tempData2;
        public double tempData3;
    }
}

