/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.PlotData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusPersister
implements StatusMessageListener,
LogMessageListener,
CommandMessageListener {
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private static SessionFactory fac;
    Map<String, DataDesc> map = new ConcurrentHashMap<String, DataDesc>();
    protected DataWriter writer = new DataWriter();
    protected Queue<Object[]> rq = new ConcurrentLinkedQueue<Object[]>();

    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersister(Properties p) {
        if (p == null) {
            p = new Properties();
        }
        StatusPersister.init(p);
        log.fine((Object)"Starting StatusPersister");
        Session sess = fac.openSession();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            String key = dd.getSrcSubsystem() + "/" + dd.getSrcName();
            this.map.put(key.toLowerCase(), dd);
            log.fine((Object)("storing " + key));
        }
        sess.close();
        Thread writerThread = new Thread(this.writer);
        writerThread.setDaemon(true);
        writerThread.start();
    }

    public void onStatusMessage(StatusMessage s) {
        KeyValueDataList encodedData = (KeyValueDataList)s.getEncodedData();
        String source = s.getOriginAgentInfo().getName();
        if (encodedData != null) {
            for (KeyValueData d : encodedData) {
                KeyValueData.KeyValueDataType type = d.getType();
                String fullKey = source + "/" + d.getKey();
                if (type == KeyValueData.KeyValueDataType.KeyValueTrendingData) {
                    this.queueImmediateScalar(d.getTimestamp(), fullKey, d.getValue());
                    continue;
                }
                if (type == KeyValueData.KeyValueDataType.KeyValueMetaData) {
                    int lastIndex = fullKey.lastIndexOf("/");
                    String metaname = fullKey.substring(lastIndex + 1);
                    String name = fullKey.replace("/" + metaname, "");
                    this.queueImmediateMetaData(d.getTimestamp(), name, metaname, (String)((Object)d.getValue()));
                    continue;
                }
                if (type != KeyValueData.KeyValueDataType.KeyValuePlotData) continue;
                PlotData plotData = new PlotData();
                plotData.setTstamp(d.getTimestamp());
                plotData.setPlotData((String)((Object)d.getValue()));
                this.addToQueue(plotData, fullKey);
            }
        }
    }

    public void onCommandMessage(CommandMessage msg) {
    }

    public void onLogMessage(LogMessage msg) {
    }

    public void queueImmediateMetaData(long tStamp, String name, String metadata, String value) {
        DataMetaData md = new DataMetaData();
        md.setName(metadata);
        md.setValue(value);
        md.setTstart(tStamp);
        this.addToQueue(md, name);
    }

    public void queueImmediateScalar(long tStamp, String name, Object d) {
        log.debug((Object)("got update " + name));
        RawData data = new RawData();
        data.setTstamp(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).doubleValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).doubleValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).doubleValue()));
        } else if (d instanceof Long) {
            data.setDoubleData(Double.valueOf(((Long)d).doubleValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(data, name);
    }

    public void addToQueue(Object data, String name) {
        this.rq.add(new Object[]{data, name});
    }

    private void persistData(RawData data, String name, org.hibernate.Session sess) {
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null) {
            return;
        }
        data.setDescr(dd);
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        List stats = dd.getDerived();
        Query q = sess.createQuery("from StatData s where s.descr = :d order by s.tstampFirst desc");
        q.setLockMode("s", LockMode.UPGRADE);
        for (StatDesc stat : stats) {
            q.setEntity("d", (Object)stat);
            q.setMaxResults(1);
            StatData sd = (StatData)q.uniqueResult();
            if (sd == null) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            if (data.getTstamp() > sd.getTstampFirst() + stat.getTimeBinWidth()) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            sd.accumulate(data);
        }
    }

    private void persistMetadata(DataMetaData md, String name, org.hibernate.Session sess) {
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        md.setRawDescr(dd);
        Query q = sess.createQuery("from DataMetaData md where rawDescr_id = :id and name = :n and tstopmillis <= 0");
        q.setParameter("id", (Object)dd.getId());
        q.setParameter("n", (Object)md.getName());
        DataMetaData oldMetaData = (DataMetaData)q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setTstop(md.getTstart());
            sess.update((Object)oldMetaData);
        }
        sess.persist((Object)md);
    }

    private void persistPlotData(PlotData pd, String name, org.hibernate.Session sess) {
        DataDesc dd = this.getDataDescription(name, "plot", sess);
        if (dd == null) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        pd.setDescr(dd);
        sess.persist((Object)pd);
    }

    private DataDesc getDataDescription(String key, String type, org.hibernate.Session sess) {
        log.debug((Object)("Looking for data description in map " + this.map + " " + key));
        DataDesc dd = this.map.get(key.toLowerCase());
        if (dd == null) {
            log.debug((Object)("Adding default Data Description for " + key));
            dd = new DataDesc();
            dd.setDataType(type);
            dd.setName(key);
            int ind = key.indexOf("/");
            dd.setSrcName(key.substring(ind + 1));
            dd.setSrcSubsystem(key.substring(0, ind));
            sess.persist((Object)dd);
            this.map.put(key.toLowerCase(), dd);
        }
        return dd;
    }

    static /* synthetic */ SessionFactory access$000() {
        return fac;
    }

    static /* synthetic */ void access$100(StatusPersister x0, RawData x1, String x2, org.hibernate.Session x3) {
        x0.persistData(x1, x2, x3);
    }

    static /* synthetic */ void access$200(StatusPersister x0, DataMetaData x1, String x2, org.hibernate.Session x3) {
        x0.persistMetadata(x1, x2, x3);
    }

    static /* synthetic */ void access$300(StatusPersister x0, PlotData x1, String x2, org.hibernate.Session x3) {
        x0.persistPlotData(x1, x2, x3);
    }

    public class DataWriter
    implements Runnable {
        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            workingList = new ArrayList<Object[]>(1000);
            sleepTime = 1000L;
            while (true) lbl-1000:
            // 5 sources

            {
                for (i = 0; i < 1000 && (d = StatusPersister.this.rq.poll()) != null; ++i) {
                    workingList.add(d);
                }
                if (workingList.isEmpty()) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ** continue;
                }
                sess = StatusPersister.access$000().openSession();
                tx = sess.beginTransaction();
                try {
                    for (Object[] o : workingList) {
                        toPersist = o[0];
                        name = (String)o[1];
                        if (toPersist instanceof RawData) {
                            StatusPersister.access$100(StatusPersister.this, (RawData)toPersist, name, (org.hibernate.Session)sess);
                            continue;
                        }
                        if (toPersist instanceof DataMetaData) {
                            StatusPersister.access$200(StatusPersister.this, (DataMetaData)toPersist, name, (org.hibernate.Session)sess);
                            continue;
                        }
                        if (toPersist instanceof PlotData) {
                            StatusPersister.access$300(StatusPersister.this, (PlotData)toPersist, name, (org.hibernate.Session)sess);
                            continue;
                        }
                        sess.persist(toPersist);
                    }
                }
                catch (Exception e) {
                    StatusPersister.log.error((Object)e.toString());
                }
                tx.commit();
                sess.close();
                workingList.clear();
            }
        }
    }
}

