package org.lsst.ccs.localdb.statusdb;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.BusMessageFilter;

/**
 * Sybsystem wrapper around a StatusPersister object
 */
public class StatusPersisterSubsystem extends Subsystem{

    private final StatusPersister persister ;
    public StatusPersisterSubsystem() {
        super("localdb",AgentInfo.AgentType.SERVICE);
        persister = new StatusPersister(null) ;
        getMessagingAccess().addStatusMessageListener(persister,BusMessageFilter.messageOrigin(null));
        getMessagingAccess().addLogMessageListener(persister,BusMessageFilter.messageOrigin(null));
        getMessagingAccess().addCommandMessageListener(persister,BusMessageFilter.messageOrigin(null));
    }
    
    

    public static void main(String[] args) {
        StatusPersisterSubsystem system = new StatusPersisterSubsystem();
        system.start() ;
        //TODO: stop correctly
        
        
        
        // TODO  start a local
        // embedded Java 6 web server
        // to be able to query the interface without a separate web server
        // by calling the new static method of DataServer (see TODO there)
        

    }
}
