/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.lsst.ccs.bus.messages.EncodedDataStatus;
import org.lsst.ccs.bus.messages.KVList;
import org.lsst.ccs.bus.messages.KeyData;
import org.lsst.ccs.bus.messages.MetadataStatus;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.KeyValueStatusListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusPersister
implements StatusMessageListener,
KeyValueStatusListener {
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private static SessionFactory fac;
    Map<String, DataDesc> map = new ConcurrentHashMap<String, DataDesc>();
    protected DataWriter writer = new DataWriter();
    protected Queue<Object[]> rq = new ConcurrentLinkedQueue<Object[]>();

    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersister(Properties p) {
        if (p == null) {
            p = new Properties();
        }
        StatusPersister.init(p);
        log.info((Object)"Starting StatusPersister");
        Session sess = fac.openSession();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            String key = String.valueOf(dd.getSrcSubsystem()) + "/" + dd.getSrcName();
            this.map.put(key.toLowerCase(), dd);
            log.info((Object)("storing " + key));
        }
        sess.close();
        Thread writerThread = new Thread(this.writer);
        writerThread.setDaemon(true);
        writerThread.start();
    }

    public void onStatusMessage(StatusMessage s) {
        if (s instanceof EncodedDataStatus) {
            this.queueEncodedData((EncodedDataStatus)s);
        } else if (s instanceof MetadataStatus) {
            this.queueMetadataStatus((MetadataStatus)s);
        } else {
            log.info((Object)("can't persist message " + s + " of class " + s.getClass()));
        }
    }

    public void onKeyValueStatusDecomposition(String source, long timeStamp, String key, Object value, int commonID) {
        this.queueImmediateScalar(timeStamp, String.valueOf(source) + '/' + key, value);
    }

    @Deprecated
    public void queueEncodedData(EncodedDataStatus encodedDataStatus) {
        for (EncodedDataStatus dataStatus : encodedDataStatus) {
            KVList list = dataStatus.getContent();
            for (KeyData keyData : list) {
                long timeStamp = dataStatus.getDataTimestamp();
                List detailsList = keyData.getContentAsList();
                for (KeyData detaileddata : detailsList) {
                    String key = detaileddata.getKey();
                    Optional optional = detaileddata.getValue();
                    if (!optional.isPresent()) continue;
                    this.queueImmediateScalar(timeStamp, key, optional.get());
                }
            }
        }
    }

    public void queueImmediateScalar(long tStamp, String name, Object d) {
        log.debug((Object)("got update " + name));
        RawData data = new RawData();
        data.setTstamp(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).floatValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).intValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).shortValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(data, name);
    }

    public void queueMetadataStatus(MetadataStatus mst) {
        this.addToQueue(mst, null);
    }

    public void addToQueue(Object data, String name) {
        this.rq.add(new Object[]{data, name});
    }

    private void persistData(RawData data, String name, org.hibernate.Session sess) {
        DataDesc dd = this.getDataDescription(name, sess);
        if (dd == null) {
            return;
        }
        data.setDescr(dd);
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        List stats = dd.getDerived();
        Query q = sess.createQuery("from StatData s where s.descr = :d order by s.tstampFirst desc");
        q.setLockMode("s", LockMode.UPGRADE);
        for (StatDesc stat : stats) {
            q.setEntity("d", (Object)stat);
            q.setMaxResults(1);
            StatData sd = (StatData)q.uniqueResult();
            if (sd == null) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            if (data.getTstamp() > sd.getTstampFirst() + stat.getTimeBinWidth()) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            sd.accumulate(data);
        }
    }

    private void persistMetadataStatus(MetadataStatus mst, org.hibernate.Session sess) {
        String dataName = String.valueOf(mst.getOriginAgentInfo().getName()) + "/" + mst.getDataName();
        DataDesc dd = this.getDataDescription(dataName, sess);
        if (dd == null) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        DataMetaData metadata = new DataMetaData();
        metadata.setName(mst.getMetadataName());
        metadata.setRawDescr(dd);
        metadata.setValue(mst.getMetadataValue());
        metadata.setTstart(mst.getTimeStamp());
        Query q = sess.createQuery("from DataMetaData md where rawDescr_id = :id and name = :n and tstopmillis <= 0");
        q.setParameter("id", (Object)dd.getId());
        q.setParameter("n", (Object)metadata.getName());
        DataMetaData oldMetaData = (DataMetaData)q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setTstop(metadata.getTstart());
            sess.update((Object)oldMetaData);
        }
        sess.persist((Object)metadata);
    }

    private DataDesc getDataDescription(String key, org.hibernate.Session sess) {
        log.debug((Object)("Looking for data description in map " + this.map + " " + key));
        DataDesc dd = this.map.get(key.toLowerCase());
        if (dd == null) {
            log.debug((Object)("Adding default Data Description for " + key));
            dd = new DataDesc();
            dd.setDataType("a");
            dd.setName(key);
            int ind = key.indexOf("/");
            dd.setSrcName(key.substring(ind + 1));
            dd.setSrcSubsystem(key.substring(0, ind));
            sess.persist((Object)dd);
            this.map.put(key.toLowerCase(), dd);
        }
        return dd;
    }

    public class DataWriter
    implements Runnable {
        @Override
        public void run() {
            ArrayList<Object[]> workingList = new ArrayList<Object[]>(1000);
            long sleepTime = 1000L;
            while (true) {
                int i = 0;
                while (i < 1000) {
                    Object[] d = StatusPersister.this.rq.poll();
                    if (d == null) break;
                    workingList.add(d);
                    ++i;
                }
                if (workingList.isEmpty()) {
                    log.info((Object)"empty list, sleeping");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                log.info((Object)("batch persisting " + workingList.size() + " objects"));
                Session sess = fac.openSession();
                Transaction tx = sess.beginTransaction();
                try {
                    for (Object[] o : workingList) {
                        if (o[0] instanceof RawData) {
                            StatusPersister.this.persistData((RawData)o[0], (String)o[1], (org.hibernate.Session)sess);
                            continue;
                        }
                        StatusPersister.this.persistMetadataStatus((MetadataStatus)o[0], (org.hibernate.Session)sess);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.toString());
                }
                tx.commit();
                sess.close();
                workingList.clear();
            }
        }
    }
}

