package org.lsst.ccs.localdb.statusdb.test;

import java.io.Serializable;
import java.util.Random;

import org.lsst.ccs.bus.messages.KVList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.logging.Logger;

// This class is used to publish trending data and exercise the trending system.
// please do not delete

/**
 * 
 * @author aubourg
 *
 */

public class TrendingTestPublisher extends Module {

    public TrendingTestPublisher() {
        super("trendingTestPublisher", 1000);
    }

    double range = 20;
    Random rnd = new Random();

    protected static Logger log = Logger.getLogger("org.lsst.ccs.framework");

    @ConfigChanger
    @Command
    public void setRange(double range) {
        System.out.println("range " + range);
        this.range = range;
    }

    @Command
    public double getRange() {
        return range;
    }

    public double getTemperature() {
        double dt = (System.currentTimeMillis() % 10000L) / 1000.;
        return -100 + range * Math.sin(dt) + rnd.nextDouble() * 3;
    }

    @Override
    public void tick() {
        setChanged();
        double t = getTemperature();
        log.info("publishing temperature " + t);
        getSubsystem().publishStatus("temp", t);
        TemperatureTrendingTest tt = new TemperatureTrendingTest();
        tt.tempData1 = t;
        tt.tempData2 = (t * 9 / 5) + 32;
        tt.tempData3 = t + 273.15;
        getSubsystem().publishStatus("temp2", tt);
        KVList list = new KVList();
        list.add("t1", t);
        list.add("t2", t + 273.15);
        getSubsystem().publishStatus(list);
    }

    public static class TemperatureTrendingTest implements Serializable {
        public double tempData1;
        public double tempData2;
        public double tempData3;
    }

}
