/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.DataValueNotification;
import org.lsst.ccs.bus.EncodedDataStatus;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.KeyData;
import org.lsst.ccs.bus.KeyValueStatusListener;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.ObjectNType;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.trending.TrendingData;
import org.lsst.ccs.localdb.Trending;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.beanutils.Optional;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusPersister
implements StatusListener,
KeyValueStatusListener {
    static Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private static SessionFactory fac;
    Map<String, DataDesc> map = new ConcurrentHashMap<String, DataDesc>();
    protected DataWriter writer = new DataWriter();
    protected Queue<Object[]> rq = new ConcurrentLinkedQueue<Object[]>();

    public static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersister(Properties p) {
        if (p == null) {
            p = new Properties();
        }
        StatusPersister.init(p);
        log.info((Object)"Starting StatusPersister", new String[0]);
        Session sess = fac.openSession();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            String key = String.valueOf(dd.getSrcSubsystem()) + "/" + dd.getSrcName();
            this.map.put(key, dd);
            log.info((Object)("storing " + key), new String[0]);
        }
        sess.close();
        new Thread(this.writer).start();
    }

    public void onStatus(BusMessage s) {
        if (s instanceof EncodedDataStatus) {
            this.queueEncodedData((EncodedDataStatus)s);
        } else if (s instanceof TrendingStatus) {
            this.queueTrendingStatus((TrendingStatus)s);
        } else if (s instanceof MetadataStatus) {
            this.queueMetadataStatus((MetadataStatus)s);
        } else {
            log.info((Object)("can't persist message " + s + " of class " + s.getClass()), new String[0]);
        }
    }

    public void onKeyValueStatusDecomposition(String source, long timeStamp, String key, Object value, int commonID) {
        this.queueImmediateScalar(timeStamp, String.valueOf(source) + '/' + key, value);
    }

    public void queueTrendingStatus(TrendingStatus pv) {
        this.queueData(pv.getOrigin(), pv.getTimeStamp(), pv.getValue());
    }

    @Deprecated
    public void queueEncodedData(EncodedDataStatus encodedDataStatus) {
        for (EncodedDataStatus dataStatus : encodedDataStatus) {
            KVList list = dataStatus.getContent();
            for (KeyData keyData : list) {
                long timeStamp = dataStatus.getDataTimestamp();
                List detailsList = keyData.getContentAsList();
                for (KeyData detaileddata : detailsList) {
                    String key = detaileddata.getKey();
                    Optional optional = detaileddata.getValue();
                    if (!optional.isPresent()) continue;
                    this.queueImmediateScalar(timeStamp, key, optional.get());
                }
            }
        }
    }

    public void queueData(String origin, long ts, Object p) {
        if (p instanceof DataValueNotification[]) {
            DataValueNotification[] vv;
            DataValueNotification[] dataValueNotificationArray = vv = (DataValueNotification[])p;
            int n = vv.length;
            int n2 = 0;
            while (n2 < n) {
                DataValueNotification v = dataValueNotificationArray[n2];
                this.queueData(origin, v.gettStamp(), v);
                ++n2;
            }
        } else if (p instanceof List && !((List)p).isEmpty() && ((List)p).get(0) instanceof DataValueNotification) {
            List vv = (List)p;
            for (DataValueNotification v : vv) {
                this.queueData(origin, v.gettStamp(), v);
            }
        } else if (p instanceof DataValueNotification) {
            DataValueNotification dvNotification = (DataValueNotification)p;
            this.queueDataValueNotification(origin, dvNotification);
        } else if (p instanceof ValueNotification[]) {
            ValueNotification[] vv;
            ValueNotification[] valueNotificationArray = vv = (ValueNotification[])p;
            int n = vv.length;
            int n3 = 0;
            while (n3 < n) {
                ValueNotification v = valueNotificationArray[n3];
                this.queueData(origin, v.gettStamp(), v);
                ++n3;
            }
        } else if (p instanceof List && !((List)p).isEmpty() && ((List)p).get(0) instanceof ValueNotification) {
            List vv = (List)p;
            for (ValueNotification v : vv) {
                this.queueData(origin, v.gettStamp(), v);
            }
        } else if (p instanceof ValueNotification) {
            ValueNotification dt = (ValueNotification)p;
            Object data = dt.getData();
            ts = dt.gettStamp();
            if (data instanceof Number || data instanceof String) {
                String key = String.valueOf(origin) + "/" + dt.getName();
                this.queueImmediateScalar(ts, key, data);
            } else {
                Field[] fields;
                Class<?> dataClass = data.getClass();
                log.debug((Object)("will try to persist class " + dataClass), new String[0]);
                boolean saveAll = dataClass.isAnnotationPresent(Trending.class);
                Field[] fieldArray = fields = dataClass.getDeclaredFields();
                int n = fields.length;
                int n4 = 0;
                while (n4 < n) {
                    Field f = fieldArray[n4];
                    if (saveAll || f.isAnnotationPresent(Trending.class)) {
                        try {
                            log.debug((Object)("persisting field " + f.getName()), new String[0]);
                            Object d = f.get(data);
                            String key = String.valueOf(origin) + "/" + dt.getName() + "/" + f.getName();
                            this.queueImmediateScalar(ts, key, d);
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            log.error((Object)"pb reading field", (Throwable)ex, new String[0]);
                        }
                    }
                    ++n4;
                }
            }
        } else if (p instanceof List) {
            Object x = ((List)p).get(0);
            log.info("can't persist a list of " + x + " class " + x != null ? p.getClass() : "null", new String[0]);
        } else {
            log.info((Object)("can't persist " + p + " class " + p.getClass()), new String[0]);
        }
    }

    public void queueDataValueNotification(String origin, DataValueNotification dv) {
        if (dv.isOfWellKnownType()) {
            String name = String.valueOf(origin) + "/" + dv.getName();
            this.queueDescribedScalar(dv.gettStamp(), name, dv.getObjectNType());
        } else {
            Map mapDesc = dv.getTrendingMap();
            if (mapDesc != null) {
                for (Map.Entry entry : mapDesc.entrySet()) {
                    String name = String.valueOf(origin) + "/" + (String)entry.getKey();
                    this.queueDescribedScalar(dv.gettStamp(), name, (ObjectNType)entry.getValue());
                }
            } else {
                Object o = dv.getData();
                this.queueObject(String.valueOf(origin) + "/" + dv.getName(), dv.gettStamp(), o);
            }
        }
    }

    private void queueObject(String name, long ts, Object data) {
        Field[] fields;
        Class<?> dataClass = data.getClass();
        log.debug((Object)("will try to persist class " + dataClass), new String[0]);
        boolean saveAll = dataClass.isAnnotationPresent(Trending.class);
        Field[] fieldArray = fields = dataClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (saveAll || f.isAnnotationPresent(Trending.class) || f.isAnnotationPresent(TrendingData.class)) {
                try {
                    log.debug((Object)("persisting field " + f.getName()), new String[0]);
                    Object d = f.get(data);
                    String key = String.valueOf(name) + "/" + f.getName();
                    this.queueImmediateScalar(ts, key, d);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    log.error((Object)"pb reading field", (Throwable)ex, new String[0]);
                }
            }
            ++n2;
        }
    }

    public void queueDescribedScalar(long tStamp, String name, ObjectNType descriptionAndValue) {
        log.debug((Object)("got update " + name), new String[0]);
        RawData data = new RawData();
        data.setTstamp(tStamp);
        String className = descriptionAndValue.getClassName();
        boolean useString = false;
        Object value = null;
        try {
            value = descriptionAndValue.getData();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"impossible deserialization", (Throwable)e, new String[0]);
            return;
        }
        if (descriptionAndValue.isOfPrimitiveType()) {
            if ("char".equals(className)) {
                useString = true;
            }
        } else {
            Class<?> dataClass = null;
            try {
                dataClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"impossible deserialization", (Throwable)e, new String[0]);
                return;
            }
            useString = !Number.class.isAssignableFrom(dataClass);
        }
        if (useString) {
            data.setStringData(String.valueOf(value));
        } else {
            data.setDoubleData(Double.valueOf(((Number)value).doubleValue()));
        }
        this.addToQueue(data, name);
    }

    public void queueImmediateScalar(long tStamp, String name, Object d) {
        log.debug((Object)("got update " + name), new String[0]);
        RawData data = new RawData();
        data.setTstamp(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).floatValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).intValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).shortValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(data, name);
    }

    public void queueMetadataStatus(MetadataStatus mst) {
        this.addToQueue(mst, null);
    }

    public void addToQueue(Object data, String name) {
        this.rq.add(new Object[]{data, name});
    }

    private void persistData(RawData data, String name, org.hibernate.Session sess) {
        DataDesc dd = this.getDataDescription(name, sess);
        if (dd == null) {
            return;
        }
        data.setDescr(dd);
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        List stats = dd.getDerived();
        Query q = sess.createQuery("from StatData s where s.descr = :d order by s.tstampFirst desc");
        q.setLockMode("s", LockMode.UPGRADE);
        for (StatDesc stat : stats) {
            q.setEntity("d", (Object)stat);
            q.setMaxResults(1);
            StatData sd = (StatData)q.uniqueResult();
            if (sd == null) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            if (data.getTstamp() > sd.getTstampFirst() + stat.getTimeBinWidth()) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            sd.accumulate(data);
        }
    }

    private void persistMetadataStatus(MetadataStatus mst, org.hibernate.Session sess) {
        String dataName = String.valueOf(mst.getOrigin()) + "/" + mst.getDataName();
        DataDesc dd = this.getDataDescription(dataName, sess);
        if (dd == null) {
            return;
        }
        sess.lock((Object)dd, LockMode.NONE);
        DataMetaData metadata = new DataMetaData();
        metadata.setName(mst.getMetadataName());
        metadata.setRawDescr(dd);
        metadata.setValue(mst.getMetadataValue());
        metadata.setTstart(mst.getTimeStamp());
        Query q = sess.createQuery("from DataMetaData md where rawDescr_id = :id and name = :n and tstopmillis <= 0");
        q.setParameter("id", (Object)dd.getId());
        q.setParameter("n", (Object)metadata.getName());
        DataMetaData oldMetaData = (DataMetaData)q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setTstop(metadata.getTstart());
            sess.update((Object)oldMetaData);
        }
        sess.persist((Object)metadata);
    }

    private DataDesc getDataDescription(String key, org.hibernate.Session sess) {
        log.debug((Object)("Looking for data description in map " + this.map + " " + key), new String[0]);
        DataDesc dd = this.map.get(key);
        if (dd == null) {
            log.debug((Object)("Adding default Data Description for " + key), new String[0]);
            dd = new DataDesc();
            dd.setDataType("a");
            dd.setName(key);
            int ind = key.indexOf("/");
            dd.setSrcName(key.substring(ind + 1));
            dd.setSrcSubsystem(key.substring(0, ind));
            sess.persist((Object)dd);
            this.map.put(key, dd);
        }
        return dd;
    }

    public class DataWriter
    implements Runnable {
        @Override
        public void run() {
            ArrayList<Object[]> workingList = new ArrayList<Object[]>(1000);
            long sleepTime = 1000L;
            while (true) {
                int i = 0;
                while (i < 1000) {
                    Object[] d = StatusPersister.this.rq.poll();
                    if (d == null) break;
                    workingList.add(d);
                    ++i;
                }
                if (workingList.isEmpty()) {
                    log.info((Object)"empty list, sleeping", new String[0]);
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                log.info((Object)("batch persisting " + workingList.size() + " objects"), new String[0]);
                Session sess = fac.openSession();
                Transaction tx = sess.beginTransaction();
                try {
                    for (Object[] o : workingList) {
                        if (o[0] instanceof RawData) {
                            StatusPersister.this.persistData((RawData)o[0], (String)o[1], (org.hibernate.Session)sess);
                            continue;
                        }
                        StatusPersister.this.persistMetadataStatus((MetadataStatus)o[0], (org.hibernate.Session)sess);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.toString(), new String[0]);
                }
                tx.commit();
                sess.close();
                workingList.clear();
            }
        }
    }
}

