package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TrendingData implements Serializable {

    @XmlElement
    DataValue[] datavalue;
    @XmlElement
    AxisValue axisvalue;

    public static class DataValue {

        @XmlAttribute
        String name = "";
        @XmlAttribute(required = true)
        double value;
        @XmlAttribute(required = false)
        String strValue;

        public DataValue(String name, double value) {
            this.name = name;
            this.value = value;
        }
        public DataValue(String name, String value) {
            this.name = name;
            this.strValue = value;
            this.value = 0.0;
        }

        public DataValue() {
        }

        public double getValue() {
            return value;
        }

        public String getName() {
            return name;
        }
        
        public String getStrValue() {
            return strValue;
        }
    }

    public static class AxisValue {

        @XmlAttribute
        String name = "";
        @XmlAttribute
        long value;
        @XmlAttribute
        long loweredge;
        @XmlAttribute
        long upperedge;

        public AxisValue(String name, long value) {
            this.name = name;
            this.value = value;
            this.loweredge = value;
            this.upperedge = value;
        }

        public AxisValue(String name, long value, long loweredge, long upperedge) {
            this.name = name;
            this.value = value;
            this.loweredge = loweredge;
            this.upperedge = upperedge;
        }

        public AxisValue() {
        }

        public long getLoweredge() {
            return loweredge;
        }

        public String getName() {
            return name;
        }

        public long getUpperedge() {
            return upperedge;
        }

        public long getValue() {
            return value;
        }
    }

    public void setAxisValue(AxisValue axisValue) {
        this.axisvalue = axisValue;
    }

    public void setDataValue(DataValue[] dataValue) {
        this.datavalue = dataValue;
    }

    public DataValue[] getDatavalue() {
        return datavalue;
    }

    public AxisValue getAxisvalue() {
        return axisvalue;
    }
    
    public double getValue(String name) {
        if ( datavalue != null ) {
            for (DataValue dv : datavalue) {
                if (dv.getName().equals(name)) {
                    return dv.getValue();
                }
            }
        }
        return Double.NaN;
    }
    
    public String getStrValue(String name) {
        if (datavalue != null) {
            for (DataValue dv : datavalue) {
                if (name.equals(dv.getName())) {
                    return dv.getStrValue();
                }
            }
        }
        return null;
    }
    
}
